// Generated by delombok at Wed Jul 13 23:21:23 CEST 2022
package de.captaingoldfish.scim.sdk.server.schemas.custom;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import de.captaingoldfish.scim.sdk.common.constants.AttributeNames;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;


/**
 * author Pascal Knueppel <br>
 * created at: 26.11.2019 - 15:17 <br>
 * <br>
 */
public class ResourceTypeAuthorization extends ScimObjectNode
{

  @java.lang.SuppressWarnings("all")
  private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(ResourceTypeAuthorization.class);

  public ResourceTypeAuthorization(Boolean authenticated,
                                   Set<String> roles,
                                   Set<String> rolesCreate,
                                   Set<String> rolesGet,
                                   Set<String> rolesUpdate,
                                   Set<String> rolesDelete)
  {
    this();
    setAuthenticated(authenticated);
    setRoles(roles);
    setRolesCreate(rolesCreate);
    setRolesGet(rolesGet);
    setRolesUpdate(rolesUpdate);
    setRolesDelete(rolesDelete);
  }

  /**
   * tells us if access to this endpoint will require authentication. Default is true
   */
  public boolean isAuthenticated()
  {
    return getBooleanAttribute(AttributeNames.Custom.AUTHENTICATED).orElse(true);
  }

  /**
   * tells us if access to this endpoint will require authentication. Default is true
   */
  public void setAuthenticated(Boolean authenticated)
  {
    setAttribute(AttributeNames.Custom.AUTHENTICATED, authenticated);
  }

  /**
   * the roles the client must have to access the resource endpoint. This setting defines the roles necessary
   * for all endpoints [create, get, list, update, patch, delete]. This setting may be overridden by other
   * attributes
   */
  public Set<String> getRoles()
  {
    return getSimpleArrayAttributeSet(AttributeNames.Custom.ROLES);
  }

  /**
   * the roles the client must have to access the resource endpoint. This setting defines the roles necessary
   * for all endpoints [create, get, list, update, patch, delete]. This setting may be overridden by other
   * attributes
   */
  public void setRoles(Set<String> roles)
  {
    setStringAttributeList(AttributeNames.Custom.ROLES, roles);
  }

  /**
   * the roles the client must have to access the resource endpoint. This setting defines the roles necessary
   * for all endpoints [create, get, list, update, patch, delete]. This setting may be overridden by other
   * attributes
   */
  public void setRoles(String... roles)
  {
    setStringAttributeList(AttributeNames.Custom.ROLES, new HashSet<>(Arrays.asList(roles)));
  }

  /**
   * the roles the client must have to access the create endpoint.(overrides the attribute "{@link #getRoles()}"
   * for the create endpoint only)
   */
  public Set<String> getRolesCreate()
  {
    return getSimpleArrayAttributeSet(AttributeNames.Custom.ROLES_CREATE);
  }

  /**
   * the roles the client must have to access the create endpoint.(overrides the attribute "{@link #getRoles()}"
   * for the create endpoint only)
   */
  public void setRolesCreate(Set<String> rolesCreate)
  {
    setStringAttributeList(AttributeNames.Custom.ROLES_CREATE, rolesCreate);
  }

  /**
   * the roles the client must have to access the create endpoint.(overrides the attribute "{@link #getRoles()}"
   * for the create endpoint only)
   */
  public void setRolesCreate(String... rolesCreate)
  {
    setStringAttributeList(AttributeNames.Custom.ROLES_CREATE, new HashSet<>(Arrays.asList(rolesCreate)));
  }

  /**
   * the roles the client must have to access the get endpoint.(overrides the attribute "{@link #getRoles()}"
   * for the get endpoint only)
   */
  public Set<String> getRolesGet()
  {
    return getSimpleArrayAttributeSet(AttributeNames.Custom.ROLES_GET);
  }

  /**
   * the roles the client must have to access the get endpoint.(overrides the attribute "{@link #getRoles()}"
   * for the get endpoint only)
   */
  public void setRolesGet(Set<String> rolesGet)
  {
    setStringAttributeList(AttributeNames.Custom.ROLES_GET, rolesGet);
  }

  /**
   * the roles the client must have to access the get endpoint.(overrides the attribute "{@link #getRoles()}"
   * for the get endpoint only)
   */
  public void setRolesGet(String... rolesGet)
  {
    setStringAttributeList(AttributeNames.Custom.ROLES_GET, new HashSet<>(Arrays.asList(rolesGet)));
  }

  /**
   * the roles the client must have to access the update endpoint.(overrides the attribute "{@link #getRoles()}"
   * for the update endpoint only)
   */
  public Set<String> getRolesUpdate()
  {
    return getSimpleArrayAttributeSet(AttributeNames.Custom.ROLES_UPDATE);
  }

  /**
   * the roles the client must have to access the update endpoint.(overrides the attribute "{@link #getRoles()}"
   * for the update endpoint only)
   */
  public void setRolesUpdate(String... rolesUpdate)
  {
    setStringAttributeList(AttributeNames.Custom.ROLES_UPDATE, new HashSet<>(Arrays.asList(rolesUpdate)));
  }

  /**
   * the roles the client must have to access the update endpoint.(overrides the attribute "{@link #getRoles()}"
   * for the update endpoint only)
   */
  public void setRolesUpdate(Set<String> rolesUpdate)
  {
    setStringAttributeList(AttributeNames.Custom.ROLES_UPDATE, rolesUpdate);
  }

  /**
   * the roles the client must have to access the delete endpoint.(overrides the attribute "{@link #getRoles()}"
   * for the delete endpoint only)
   */
  public Set<String> getRolesDelete()
  {
    return getSimpleArrayAttributeSet(AttributeNames.Custom.ROLES_DELETE);
  }

  /**
   * the roles the client must have to access the delete endpoint.(overrides the attribute "{@link #getRoles()}"
   * for the delete endpoint only)
   */
  public void setRolesDelete(Set<String> rolesDelete)
  {
    setStringAttributeList(AttributeNames.Custom.ROLES_DELETE, rolesDelete);
  }

  /**
   * the roles the client must have to access the delete endpoint.(overrides the attribute "{@link #getRoles()}"
   * for the delete endpoint only)
   */
  public void setRolesDelete(String... rolesDelete)
  {
    setStringAttributeList(AttributeNames.Custom.ROLES_DELETE, new HashSet<>(Arrays.asList(rolesDelete)));
  }


  @java.lang.SuppressWarnings("all")
  public static class ResourceTypeAuthorizationBuilder
  {

    @java.lang.SuppressWarnings("all")
    private Boolean authenticated;

    @java.lang.SuppressWarnings("all")
    private Set<String> roles;

    @java.lang.SuppressWarnings("all")
    private Set<String> rolesCreate;

    @java.lang.SuppressWarnings("all")
    private Set<String> rolesGet;

    @java.lang.SuppressWarnings("all")
    private Set<String> rolesUpdate;

    @java.lang.SuppressWarnings("all")
    private Set<String> rolesDelete;

    @java.lang.SuppressWarnings("all")
    ResourceTypeAuthorizationBuilder()
    {}

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ResourceTypeAuthorization.ResourceTypeAuthorizationBuilder authenticated(final Boolean authenticated)
    {
      this.authenticated = authenticated;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ResourceTypeAuthorization.ResourceTypeAuthorizationBuilder roles(final Set<String> roles)
    {
      this.roles = roles;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ResourceTypeAuthorization.ResourceTypeAuthorizationBuilder rolesCreate(final Set<String> rolesCreate)
    {
      this.rolesCreate = rolesCreate;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ResourceTypeAuthorization.ResourceTypeAuthorizationBuilder rolesGet(final Set<String> rolesGet)
    {
      this.rolesGet = rolesGet;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ResourceTypeAuthorization.ResourceTypeAuthorizationBuilder rolesUpdate(final Set<String> rolesUpdate)
    {
      this.rolesUpdate = rolesUpdate;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ResourceTypeAuthorization.ResourceTypeAuthorizationBuilder rolesDelete(final Set<String> rolesDelete)
    {
      this.rolesDelete = rolesDelete;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public ResourceTypeAuthorization build()
    {
      return new ResourceTypeAuthorization(this.authenticated, this.roles, this.rolesCreate, this.rolesGet,
                                           this.rolesUpdate, this.rolesDelete);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString()
    {
      return "ResourceTypeAuthorization.ResourceTypeAuthorizationBuilder(authenticated=" + this.authenticated
             + ", roles=" + this.roles + ", rolesCreate=" + this.rolesCreate + ", rolesGet=" + this.rolesGet
             + ", rolesUpdate=" + this.rolesUpdate + ", rolesDelete=" + this.rolesDelete + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  public static ResourceTypeAuthorization.ResourceTypeAuthorizationBuilder builder()
  {
    return new ResourceTypeAuthorization.ResourceTypeAuthorizationBuilder();
  }

  @java.lang.SuppressWarnings("all")
  public ResourceTypeAuthorization()
  {}
}
