// Generated by delombok at Thu Mar 31 09:31:31 CEST 2022
package de.captaingoldfish.scim.sdk.server.filter.antlr;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import de.captaingoldfish.scim.sdk.common.constants.SchemaUris;


/**
 * author Pascal Knueppel <br>
 * created at: 16.10.2019 - 12:24 <br>
 * <br>
 * represents the name of an attribute and will also hold its meta data
 */
public class FilterAttributeName
{

  /**
   * the resource uri to which this attribute belongs e.g. {@link SchemaUris#ENTERPRISE_USER_URI}
   */
  private String resourceUri;

  private String attributeName;

  /**
   * the fully qualified name of this attribute {@link #resourceUri} + {@link #getShortName()}
   */
  private String fullName;

  /**
   * the name of the parent attribute in case of bracket filter notation
   */
  private String parentAttributeName;

  /**
   * the name of the sub attribute in case of bracket filter notation
   */
  private String complexSubAttributeName;

  public FilterAttributeName(ScimFilterParser.ValuePathContext valuePathContext,
                             ScimFilterParser.AttributePathContext attributePathContext)
  {
    this(valuePathContext == null ? null : valuePathContext.attributePath().attribute.getText(), attributePathContext);
  }

  public FilterAttributeName(String parentName, ScimFilterParser.AttributePathContext attributePathContext)
  {
    this.parentAttributeName = parentName == null ? null : (parentName + ".");
    this.attributeName = attributePathContext.attribute.getText();
    this.complexSubAttributeName = attributePathContext.subattribute == null ? null
      : attributePathContext.subattribute.getText();
    this.resourceUri = resolveResourceUri(attributePathContext).orElse(null);
    this.fullName = (resourceUri == null ? "" : StringUtils.stripToEmpty(resourceUri) + ":") + getShortName();
  }

  public FilterAttributeName(String attributeName)
  {
    Pattern pattern = Pattern.compile("(([\\w:.]+):)?(\\w+)(\\.)?(\\w+)?");
    Matcher matcher = pattern.matcher(attributeName);
    if (matcher.matches())
    {
      this.resourceUri = matcher.group(2);
      this.attributeName = matcher.group(3);
      this.complexSubAttributeName = matcher.group(5);
    }
    this.fullName = attributeName;
  }

  /**
   * tries to resolve the resourceUri value
   *
   * @param attributePathContext the antlr attribute path context
   * @return the resourceUri
   */
  private Optional<String> resolveResourceUri(ScimFilterParser.AttributePathContext attributePathContext)
  {
    if (attributePathContext.resourceUri == null)
    {
      return Optional.empty();
    }
    String resourceUri = StringUtils.stripToEmpty(attributePathContext.resourceUri.getText());
    return Optional.of(StringUtils.stripToNull(resourceUri.replaceFirst(":$", "")));
  }

  /**
   * the short name of the attribute e.g. 'userName' or 'name.givenName'
   */
  public String getShortName()
  {
    return StringUtils.stripToNull(StringUtils.stripToEmpty(parentAttributeName)
                                   + StringUtils.stripToEmpty(attributeName)
                                   + StringUtils.stripToEmpty(this.complexSubAttributeName == null ? null
                                     : "." + this.complexSubAttributeName));
  }

  @Override
  public String toString()
  {
    return fullName;
  }

  /**
   * the resource uri to which this attribute belongs e.g. {@link SchemaUris#ENTERPRISE_USER_URI}
   */
  @java.lang.SuppressWarnings("all")
  public String getResourceUri()
  {
    return this.resourceUri;
  }

  @java.lang.SuppressWarnings("all")
  public String getAttributeName()
  {
    return this.attributeName;
  }

  /**
   * the fully qualified name of this attribute {@link #resourceUri} + {@link #getShortName()}
   */
  @java.lang.SuppressWarnings("all")
  public String getFullName()
  {
    return this.fullName;
  }

  /**
   * the name of the parent attribute in case of bracket filter notation
   */
  @java.lang.SuppressWarnings("all")
  public String getParentAttributeName()
  {
    return this.parentAttributeName;
  }

  /**
   * the name of the sub attribute in case of bracket filter notation
   */
  @java.lang.SuppressWarnings("all")
  public String getComplexSubAttributeName()
  {
    return this.complexSubAttributeName;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public boolean equals(final java.lang.Object o)
  {
    if (o == this)
      return true;
    if (!(o instanceof FilterAttributeName))
      return false;
    final FilterAttributeName other = (FilterAttributeName)o;
    if (!other.canEqual((java.lang.Object)this))
      return false;
    final java.lang.Object this$resourceUri = this.getResourceUri();
    final java.lang.Object other$resourceUri = other.getResourceUri();
    if (this$resourceUri == null ? other$resourceUri != null : !this$resourceUri.equals(other$resourceUri))
      return false;
    final java.lang.Object this$attributeName = this.getAttributeName();
    final java.lang.Object other$attributeName = other.getAttributeName();
    if (this$attributeName == null ? other$attributeName != null : !this$attributeName.equals(other$attributeName))
      return false;
    final java.lang.Object this$fullName = this.getFullName();
    final java.lang.Object other$fullName = other.getFullName();
    if (this$fullName == null ? other$fullName != null : !this$fullName.equals(other$fullName))
      return false;
    final java.lang.Object this$parentAttributeName = this.getParentAttributeName();
    final java.lang.Object other$parentAttributeName = other.getParentAttributeName();
    if (this$parentAttributeName == null ? other$parentAttributeName != null
      : !this$parentAttributeName.equals(other$parentAttributeName))
      return false;
    final java.lang.Object this$complexSubAttributeName = this.getComplexSubAttributeName();
    final java.lang.Object other$complexSubAttributeName = other.getComplexSubAttributeName();
    if (this$complexSubAttributeName == null ? other$complexSubAttributeName != null
      : !this$complexSubAttributeName.equals(other$complexSubAttributeName))
      return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  protected boolean canEqual(final java.lang.Object other)
  {
    return other instanceof FilterAttributeName;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public int hashCode()
  {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $resourceUri = this.getResourceUri();
    result = result * PRIME + ($resourceUri == null ? 43 : $resourceUri.hashCode());
    final java.lang.Object $attributeName = this.getAttributeName();
    result = result * PRIME + ($attributeName == null ? 43 : $attributeName.hashCode());
    final java.lang.Object $fullName = this.getFullName();
    result = result * PRIME + ($fullName == null ? 43 : $fullName.hashCode());
    final java.lang.Object $parentAttributeName = this.getParentAttributeName();
    result = result * PRIME + ($parentAttributeName == null ? 43 : $parentAttributeName.hashCode());
    final java.lang.Object $complexSubAttributeName = this.getComplexSubAttributeName();
    result = result * PRIME + ($complexSubAttributeName == null ? 43 : $complexSubAttributeName.hashCode());
    return result;
  }
}
