/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.utils;

import de.captaingoldfish.scim.sdk.common.constants.enums.HttpMethod;
import de.captaingoldfish.scim.sdk.common.exceptions.BadRequestException;
import de.captaingoldfish.scim.sdk.common.exceptions.InternalServerException;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceTypeFactory;
import de.captaingoldfish.scim.sdk.server.utils.RequestUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UriInfos {
    private static final Logger log = LoggerFactory.getLogger(UriInfos.class);
    private final String resourceEndpoint;
    private final boolean searchRequest;
    private final String baseUri;
    private final Map<String, String> queryParameters;
    private final ResourceType resourceType;
    private final HttpMethod httpMethod;
    private String resourceId;
    private Map<String, String> httpHeaders;

    private UriInfos(String resourceEndpoint, String resourceId, boolean searchRequest, String baseUri, String queryParameters, ResourceType resourceType, HttpMethod httpMethod, Map<String, String> httpHeaders) {
        this.resourceEndpoint = resourceEndpoint;
        this.resourceId = resourceId;
        this.searchRequest = searchRequest;
        this.baseUri = baseUri;
        this.queryParameters = queryParameters == null ? new HashMap() : RequestUtils.getQueryParameters(queryParameters);
        this.resourceType = resourceType;
        this.httpMethod = Objects.requireNonNull(httpMethod);
        this.validateUriInfos(resourceType);
        this.httpHeaders = this.validateHttpHeaders(httpHeaders);
    }

    public static UriInfos getRequestUrlInfos(ResourceTypeFactory resourceTypeFactory, String requestUrl, HttpMethod httpMethod, Map<String, String> httpHeaders) {
        URL url = UriInfos.toUrl(requestUrl);
        String[] pathParts = url.getPath().split("/");
        ResourceType resourceType = UriInfos.getResourceType(resourceTypeFactory, pathParts);
        if (UriInfos.isBulkRequest(httpMethod, resourceType)) {
            return UriInfos.builder().baseUri(StringUtils.substringBeforeLast((String)requestUrl, (String)"/Bulk")).resourceEndpoint("/Bulk").httpMethod(httpMethod).httpHeaders(httpHeaders).build();
        }
        boolean endsOfSearch = "/.search".endsWith(pathParts[pathParts.length - 1]);
        boolean endsOfResource = resourceType.getEndpoint().endsWith(pathParts[pathParts.length - 1]);
        String resourceId = endsOfSearch ? null : (endsOfResource ? null : pathParts[pathParts.length - 1]);
        boolean searchRequest = endsOfSearch && HttpMethod.POST.equals((Object)httpMethod) || HttpMethod.GET.equals((Object)httpMethod) && resourceId == null;
        String baseUri = StringUtils.substringBeforeLast((String)requestUrl, (String)resourceType.getEndpoint());
        UriInfos uriInfos = UriInfos.builder().baseUri(baseUri).searchRequest(searchRequest).resourceEndpoint(resourceType.getEndpoint()).resourceId(resourceId).queryParameters(url.getQuery()).resourceType(resourceType).httpMethod(httpMethod).httpHeaders(httpHeaders).build();
        return uriInfos;
    }

    private static boolean isBulkRequest(HttpMethod httpMethod, ResourceType resourceType) {
        if (resourceType == null) {
            if (HttpMethod.POST.equals((Object)httpMethod)) {
                return true;
            }
            throw new BadRequestException("Bulk endpoint can only be reached with a HTTP-POST request", null, null);
        }
        return false;
    }

    private static ResourceType getResourceType(ResourceTypeFactory resourceTypeFactory, String[] urlParts) {
        if ("/Bulk".endsWith(urlParts[urlParts.length - 1])) {
            return null;
        }
        String lastPathPart = "/" + urlParts[urlParts.length - 1];
        String nextToLastPathPart = "/" + urlParts[urlParts.length - 2];
        ResourceType resourceType = Optional.ofNullable(resourceTypeFactory.getResourceType(nextToLastPathPart)).orElse(resourceTypeFactory.getResourceType(lastPathPart));
        if (resourceType != null) {
            return resourceType;
        }
        throw new BadRequestException("the request url does not point to a registered resource type. Registered resource types are: [" + resourceTypeFactory.getAllResourceTypes().stream().map(ResourceType::getEndpoint).collect(Collectors.joining(",")) + "]", null, "invalidParameters");
    }

    private static URL toUrl(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new InternalServerException(e.getMessage(), (Throwable)e, null);
        }
    }

    private Map<String, String> validateHttpHeaders(Map<String, String> httpHeaders) {
        if (httpHeaders == null) {
            throw new InternalServerException("missing http headers. This is not a client error!", null, null);
        }
        if (httpHeaders.get("/Bulk") != null && httpHeaders.size() <= 2) {
            httpHeaders.remove("/Bulk");
            return httpHeaders;
        }
        String contentType = httpHeaders.keySet().stream().filter(header -> StringUtils.equalsIgnoreCase((CharSequence)header, (CharSequence)"Content-Type")).findAny().map(httpHeaders::get).orElse(null);
        if ((HttpMethod.POST.equals((Object)this.httpMethod) || HttpMethod.PUT.equals((Object)this.httpMethod) || HttpMethod.PATCH.equals((Object)this.httpMethod)) && (contentType == null || !StringUtils.startsWith((CharSequence)contentType, (CharSequence)"application/scim+json"))) {
            throw new BadRequestException("Invalid content type. Was '" + contentType + "' but should be " + "application/scim+json", null, null);
        }
        return httpHeaders;
    }

    private void validateUriInfos(ResourceType resourceType) {
        switch (this.httpMethod) {
            case POST: {
                if (!StringUtils.isNotBlank((CharSequence)this.getResourceId())) break;
                throw new BadRequestException("ID values in the path are not allowed on '" + this.httpMethod + "' requests", null, "invalidParameters");
            }
            case PUT: 
            case PATCH: 
            case DELETE: {
                if (resourceType.getFeatures().isSingletonEndpoint() || !StringUtils.isBlank((CharSequence)this.getResourceId())) break;
                throw new BadRequestException("missing ID value in request path for method '" + this.httpMethod + "'", null, "invalidParameters");
            }
        }
    }

    public String toString() {
        return this.baseUri + this.resourceEndpoint + (StringUtils.isBlank((CharSequence)this.resourceId) ? "" : "/" + this.resourceId);
    }

    public static UriInfosBuilder builder() {
        return new UriInfosBuilder();
    }

    public String getResourceEndpoint() {
        return this.resourceEndpoint;
    }

    public boolean isSearchRequest() {
        return this.searchRequest;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public Map<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public static class UriInfosBuilder {
        private String resourceEndpoint;
        private String resourceId;
        private boolean searchRequest;
        private String baseUri;
        private String queryParameters;
        private ResourceType resourceType;
        private HttpMethod httpMethod;
        private Map<String, String> httpHeaders;

        UriInfosBuilder() {
        }

        public UriInfosBuilder resourceEndpoint(String resourceEndpoint) {
            this.resourceEndpoint = resourceEndpoint;
            return this;
        }

        public UriInfosBuilder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public UriInfosBuilder searchRequest(boolean searchRequest) {
            this.searchRequest = searchRequest;
            return this;
        }

        public UriInfosBuilder baseUri(String baseUri) {
            this.baseUri = baseUri;
            return this;
        }

        public UriInfosBuilder queryParameters(String queryParameters) {
            this.queryParameters = queryParameters;
            return this;
        }

        public UriInfosBuilder resourceType(ResourceType resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public UriInfosBuilder httpMethod(HttpMethod httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public UriInfosBuilder httpHeaders(Map<String, String> httpHeaders) {
            this.httpHeaders = httpHeaders;
            return this;
        }

        public UriInfos build() {
            return new UriInfos(this.resourceEndpoint, this.resourceId, this.searchRequest, this.baseUri, this.queryParameters, this.resourceType, this.httpMethod, this.httpHeaders);
        }

        public String toString() {
            return "UriInfos.UriInfosBuilder(resourceEndpoint=" + this.resourceEndpoint + ", resourceId=" + this.resourceId + ", searchRequest=" + this.searchRequest + ", baseUri=" + this.baseUri + ", queryParameters=" + this.queryParameters + ", resourceType=" + (Object)((Object)this.resourceType) + ", httpMethod=" + this.httpMethod + ", httpHeaders=" + this.httpHeaders + ")";
        }
    }
}

