/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.schemas.validation;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.HttpMethod;
import de.captaingoldfish.scim.sdk.common.exceptions.DocumentValidationException;
import de.captaingoldfish.scim.sdk.common.exceptions.ScimException;
import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import de.captaingoldfish.scim.sdk.common.resources.complex.Meta;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import de.captaingoldfish.scim.sdk.server.endpoints.validation.ValidationContext;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import de.captaingoldfish.scim.sdk.server.schemas.validation.AbstractResourceValidator;
import de.captaingoldfish.scim.sdk.server.schemas.validation.RequestSchemaValidator;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestResourceValidator
extends AbstractResourceValidator {
    private static final Logger log = LoggerFactory.getLogger(RequestResourceValidator.class);

    public RequestResourceValidator(ResourceType resourceType, HttpMethod httpMethod) {
        super(resourceType, new RequestSchemaValidator(resourceType.getResourceHandlerImpl().getType(), httpMethod, new ValidationContext(resourceType)));
    }

    public ValidationContext getValidationContext() {
        return Optional.ofNullable((RequestSchemaValidator)this.getSchemaValidator()).map(RequestSchemaValidator::getValidationContext).orElse(null);
    }

    @Override
    public ScimObjectNode validateDocument(JsonNode resource) {
        if (log.isTraceEnabled()) {
            log.trace("Validating resource '{}' for resourceType '{}'", (Object)resource.toPrettyString(), (Object)this.getResourceType().getName());
        }
        try {
            boolean isEmpty;
            ScimObjectNode validatedResource = super.validateDocument(resource);
            if (resource.has("meta")) {
                validatedResource.set("meta", resource.get("meta"));
            }
            boolean containsOnlyAttributesSchemasAndMeta = validatedResource.size() == 2 && validatedResource.has("schemas") && validatedResource.has("meta");
            boolean bl = isEmpty = validatedResource.isEmpty() || containsOnlyAttributesSchemasAndMeta;
            if (isEmpty) {
                String errorMessage = String.format("Request document is invalid it does not contain processable data '%s'", resource);
                this.getValidationContext().addError(errorMessage);
            }
            return validatedResource;
        }
        catch (DocumentValidationException ex) {
            ValidationContext validationContext = this.getValidationContext();
            Optional.ofNullable(validationContext).ifPresent(context -> context.addExceptionMessages((ScimException)((Object)((Object)((Object)ex)))));
            ResourceNode resourceNode = (ResourceNode)JsonHelper.getNewInstance(this.getResourceType().getResourceHandlerImpl().getType());
            resourceNode.setMeta(Meta.builder().build());
            return resourceNode;
        }
    }

    @Override
    protected int getHttpStatusCode() {
        return 400;
    }
}

