/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.endpoints.validation;

import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;
import de.captaingoldfish.scim.sdk.server.endpoints.Context;
import de.captaingoldfish.scim.sdk.server.endpoints.ResourceHandler;
import de.captaingoldfish.scim.sdk.server.endpoints.validation.RequestContextException;
import de.captaingoldfish.scim.sdk.server.endpoints.validation.RequestValidator;
import de.captaingoldfish.scim.sdk.server.endpoints.validation.ValidationContext;
import de.captaingoldfish.scim.sdk.server.schemas.validation.RequestResourceValidator;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class RequestValidatorHandler {
    private final ValidationContext validationContext;
    private final RequestValidator requestValidator;
    private final Context requestContext;

    public RequestValidatorHandler(ResourceHandler resourceHandler, RequestResourceValidator requestResourceValidator, Context requestContext) {
        this.requestValidator = resourceHandler.getRequestValidator();
        this.validationContext = requestResourceValidator.getValidationContext();
        this.requestContext = requestContext;
    }

    public void validateCreate(ResourceNode resourceNode) {
        this.validateRequest(validator -> validator.validateCreate(resourceNode, this.validationContext, this.requestContext));
    }

    public void validateUpdate(Supplier<ResourceNode> oldResourceSupplier, ResourceNode newResource) {
        this.validateRequest(validator -> validator.validateUpdate(oldResourceSupplier, newResource, this.validationContext, this.requestContext));
    }

    private void validateRequest(Consumer<RequestValidator> validate) {
        if (this.requestValidator == null) {
            this.checkForErrors();
            return;
        }
        validate.accept(this.requestValidator);
        this.checkForErrors();
    }

    private void checkForErrors() {
        if (this.validationContext.hasErrors()) {
            this.validationContext.logErrors();
            throw new RequestContextException(this.validationContext);
        }
    }
}

