/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.endpoints;

import de.captaingoldfish.scim.sdk.server.endpoints.authorize.Authorization;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;

public class Context {
    private Authorization authorization;
    private Function<String, String> resourceReferenceUrl;
    private BiFunction<String, String, String> crossResourceReferenceUrl;

    public Context(Authorization authorization) {
        this.authorization = authorization;
    }

    public String getResourceReferenceUrl(String id) {
        return this.resourceReferenceUrl.apply(id);
    }

    public Optional<String> getCrossResourceReferenceUrl(String id, String resourceName) {
        return Optional.ofNullable(this.crossResourceReferenceUrl.apply(resourceName, id));
    }

    public static ContextBuilder builder() {
        return new ContextBuilder();
    }

    public Authorization getAuthorization() {
        return this.authorization;
    }

    public Context() {
    }

    private Function<String, String> getResourceReferenceUrl() {
        return this.resourceReferenceUrl;
    }

    void setResourceReferenceUrl(Function<String, String> resourceReferenceUrl) {
        this.resourceReferenceUrl = resourceReferenceUrl;
    }

    private BiFunction<String, String, String> getCrossResourceReferenceUrl() {
        return this.crossResourceReferenceUrl;
    }

    void setCrossResourceReferenceUrl(BiFunction<String, String, String> crossResourceReferenceUrl) {
        this.crossResourceReferenceUrl = crossResourceReferenceUrl;
    }

    public static class ContextBuilder {
        private Authorization authorization;

        ContextBuilder() {
        }

        public ContextBuilder authorization(Authorization authorization) {
            this.authorization = authorization;
            return this;
        }

        public Context build() {
            return new Context(this.authorization);
        }

        public String toString() {
            return "Context.ContextBuilder(authorization=" + this.authorization + ")";
        }
    }
}

