/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.schemas.validation;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.ReferenceTypes;
import de.captaingoldfish.scim.sdk.common.constants.enums.Type;
import de.captaingoldfish.scim.sdk.common.exceptions.InvalidDateTimeRepresentationException;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimBooleanNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimDoubleNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimIntNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimLongNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimTextNode;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.common.utils.TimeUtils;
import de.captaingoldfish.scim.sdk.server.schemas.exceptions.AttributeValidationException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SimpleAttributeValidator {
    private static final Logger log = LoggerFactory.getLogger(SimpleAttributeValidator.class);

    protected static boolean isSimpleNode(JsonNode attribute) {
        return attribute.isNull() || !attribute.isArray() && !attribute.isObject();
    }

    public static JsonNode parseNodeType(SchemaAttribute schemaAttribute, JsonNode attribute) {
        log.trace("Validating simple attribute '{}'", (Object)schemaAttribute.getScimNodeName());
        if (!SimpleAttributeValidator.isSimpleNode(attribute)) {
            String errorMessage = String.format("Attribute '%s' is expected to be a simple attribute but is '%s'", schemaAttribute.getFullResourceName(), attribute);
            throw new AttributeValidationException(schemaAttribute, errorMessage);
        }
        SimpleAttributeValidator.checkCanonicalValues(schemaAttribute, attribute);
        Type type = schemaAttribute.getType();
        switch (type) {
            case STRING: {
                SimpleAttributeValidator.isNodeOfExpectedType(schemaAttribute, attribute, jsonNode -> jsonNode.isTextual() || jsonNode.isObject());
                return new ScimTextNode(schemaAttribute, attribute.isTextual() ? attribute.textValue() : attribute.toString());
            }
            case BOOLEAN: {
                SimpleAttributeValidator.isNodeOfExpectedType(schemaAttribute, attribute, JsonNode::isBoolean);
                return new ScimBooleanNode(schemaAttribute, attribute.booleanValue());
            }
            case INTEGER: {
                SimpleAttributeValidator.isNodeOfExpectedType(schemaAttribute, attribute, jsonNode -> jsonNode.isInt() || jsonNode.isLong() || jsonNode.isBigDecimal());
                if ((long)attribute.intValue() == attribute.longValue()) {
                    return new ScimIntNode(schemaAttribute, attribute.intValue());
                }
                return new ScimLongNode(schemaAttribute, attribute.longValue());
            }
            case DECIMAL: {
                SimpleAttributeValidator.isNodeOfExpectedType(schemaAttribute, attribute, jsonNode -> jsonNode.isInt() || jsonNode.isLong() || jsonNode.isFloat() || jsonNode.isDouble() || jsonNode.isBigDecimal());
                return new ScimDoubleNode(schemaAttribute, attribute.doubleValue());
            }
            case DATE_TIME: {
                SimpleAttributeValidator.isNodeOfExpectedType(schemaAttribute, attribute, JsonNode::isTextual);
                SimpleAttributeValidator.parseDateTime(schemaAttribute, attribute.textValue());
                return new ScimTextNode(schemaAttribute, attribute.textValue());
            }
        }
        SimpleAttributeValidator.isNodeOfExpectedType(schemaAttribute, attribute, JsonNode::isTextual);
        SimpleAttributeValidator.validateValueNodeWithReferenceTypes(schemaAttribute, attribute);
        return new ScimTextNode(schemaAttribute, attribute.textValue());
    }

    private static void isNodeOfExpectedType(SchemaAttribute schemaAttribute, JsonNode valueNode, Function<JsonNode, Boolean> ofType) {
        boolean isOfType = ofType.apply(valueNode);
        if (!isOfType) {
            Type type = schemaAttribute.getType();
            String errorMessage = String.format("Value of attribute '%s' is not of type '%s' but of type '%s' with value '%s'", schemaAttribute.getFullResourceName(), type.getValue(), StringUtils.lowerCase((String)valueNode.getNodeType().toString()), valueNode);
            throw new AttributeValidationException(schemaAttribute, errorMessage);
        }
    }

    private static void parseDateTime(SchemaAttribute schemaAttribute, String textValue) {
        try {
            TimeUtils.parseDateTime((String)textValue);
        }
        catch (InvalidDateTimeRepresentationException ex) {
            throw new AttributeValidationException(schemaAttribute, String.format("Given value is not a valid dateTime '%s'", textValue));
        }
    }

    private static void validateValueNodeWithReferenceTypes(SchemaAttribute schemaAttribute, JsonNode valueNode) {
        boolean isValidReferenceType = false;
        for (ReferenceTypes referenceType : schemaAttribute.getReferenceTypes()) {
            switch (referenceType) {
                case RESOURCE: 
                case URI: {
                    isValidReferenceType = SimpleAttributeValidator.parseUri(valueNode.textValue());
                    break;
                }
                case URL: {
                    isValidReferenceType = SimpleAttributeValidator.parseUrl(valueNode.textValue());
                    break;
                }
                default: {
                    isValidReferenceType = true;
                }
            }
            if (!isValidReferenceType) continue;
            break;
        }
        if (!isValidReferenceType) {
            String errorMessage = String.format("Attribute '%s' is a referenceType and must apply to one of the following types '%s' but value is '%s'", schemaAttribute.getFullResourceName(), schemaAttribute.getReferenceTypes(), valueNode.textValue());
            throw new AttributeValidationException(schemaAttribute, errorMessage);
        }
    }

    private static boolean parseUrl(String textValue) {
        try {
            new URL(textValue);
            return true;
        }
        catch (MalformedURLException ex) {
            log.debug(ex.getMessage());
            return false;
        }
    }

    private static boolean parseUri(String textValue) {
        try {
            new URI(textValue);
            return true;
        }
        catch (URISyntaxException ex) {
            log.debug(ex.getMessage());
            return false;
        }
    }

    protected static void checkCanonicalValues(SchemaAttribute schemaAttribute, JsonNode valueNode) {
        if (schemaAttribute.getCanonicalValues().isEmpty()) {
            return;
        }
        String value = valueNode.textValue();
        AtomicBoolean caseInsensitiveMatch = new AtomicBoolean(false);
        Predicate<String> compare = s -> {
            if (schemaAttribute.isCaseExact()) {
                caseInsensitiveMatch.compareAndSet(false, StringUtils.equalsIgnoreCase((CharSequence)s, (CharSequence)value));
                return StringUtils.equals((CharSequence)s, (CharSequence)value);
            }
            return StringUtils.equalsIgnoreCase((CharSequence)s, (CharSequence)value);
        };
        if (schemaAttribute.getCanonicalValues().stream().noneMatch(compare)) {
            String errorMessage = schemaAttribute.isCaseExact() && caseInsensitiveMatch.get() ? String.format("Attribute '%s' is caseExact and does not match its canonicalValues '%s' actual value is '%s'", schemaAttribute.getFullResourceName(), schemaAttribute.getCanonicalValues(), value) : String.format("Attribute '%s' does not match one of its canonicalValues '%s' actual value is '%s'", schemaAttribute.getFullResourceName(), schemaAttribute.getCanonicalValues(), value);
            throw new AttributeValidationException(schemaAttribute, errorMessage);
        }
    }

    private SimpleAttributeValidator() {
    }
}

