/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.patch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.PatchOp;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MsAzureWorkaroundHandler {
    private static final Logger log = LoggerFactory.getLogger(MsAzureWorkaroundHandler.class);
    private final PatchOp patchOp;
    private final String path;
    private final List<String> values;

    public String fixPath() {
        if (!PatchOp.REMOVE.equals((Object)this.patchOp)) {
            log.trace("[MS Azure workaround] only handling 'REMOVE' requests");
            return this.path;
        }
        if (this.values.isEmpty()) {
            log.trace("[MS Azure workaround] workaround not executed for values-list is empty");
            return this.path;
        }
        StringBuilder newPath = new StringBuilder(this.path).append('[');
        for (int i = 0; i < this.values.size(); ++i) {
            String value;
            if (i > 0) {
                newPath.append(" or ");
            }
            if (!JsonHelper.isValidJson((String)(value = this.values.get(i)))) {
                log.trace("[MS Azure workaround] attribute in 'value' operand is not valid json: {}", (Object)value);
                return this.path;
            }
            JsonNode jsonNode = JsonHelper.readJsonDocument((String)value);
            boolean isNodeAnObject = Optional.ofNullable(jsonNode).map(JsonNode::isObject).orElse(false);
            if (!isNodeAnObject) {
                log.trace("[MS Azure workaround] attribute in 'value' operand is not an object: {}", (Object)value);
                return this.path;
            }
            ObjectNode objectNode = (ObjectNode)jsonNode;
            if (objectNode.size() != 1) {
                log.trace("[MS Azure workaround] workaround not executed for 'value' operand object has more than one attributes: {}", (Object)objectNode.toPrettyString());
                return this.path;
            }
            String fieldName = (String)objectNode.fieldNames().next();
            JsonNode valueNode = objectNode.get(fieldName);
            if (valueNode.isObject() || valueNode.isArray()) {
                log.trace("[MS Azure workaround] workaround not executed for attribute in value 'operand' is not a simple type: {}", (Object)valueNode.toPrettyString());
                return this.path;
            }
            newPath.append(fieldName).append(" eq \"").append(valueNode.textValue()).append("\"");
        }
        this.values.clear();
        return newPath.append(']').toString();
    }

    public MsAzureWorkaroundHandler(PatchOp patchOp, String path, List<String> values) {
        this.patchOp = patchOp;
        this.path = path;
        this.values = values;
    }
}

