/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.endpoints;

import de.captaingoldfish.scim.sdk.common.constants.enums.HttpMethod;
import de.captaingoldfish.scim.sdk.common.exceptions.InternalServerException;
import de.captaingoldfish.scim.sdk.common.exceptions.ScimException;
import de.captaingoldfish.scim.sdk.common.exceptions.UnauthenticatedException;
import de.captaingoldfish.scim.sdk.common.resources.ServiceProvider;
import de.captaingoldfish.scim.sdk.common.response.BulkResponse;
import de.captaingoldfish.scim.sdk.common.response.ErrorResponse;
import de.captaingoldfish.scim.sdk.common.response.ScimResponse;
import de.captaingoldfish.scim.sdk.server.endpoints.BulkEndpoint;
import de.captaingoldfish.scim.sdk.server.endpoints.Context;
import de.captaingoldfish.scim.sdk.server.endpoints.EndpointDefinition;
import de.captaingoldfish.scim.sdk.server.endpoints.ResourceEndpointHandler;
import de.captaingoldfish.scim.sdk.server.endpoints.authorize.Authorization;
import de.captaingoldfish.scim.sdk.server.endpoints.features.EndpointFeatureHandler;
import de.captaingoldfish.scim.sdk.server.endpoints.features.EndpointType;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import de.captaingoldfish.scim.sdk.server.utils.RequestUtils;
import de.captaingoldfish.scim.sdk.server.utils.UriInfos;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceEndpoint
extends ResourceEndpointHandler {
    private static final Logger log = LoggerFactory.getLogger(ResourceEndpoint.class);

    public ResourceEndpoint(ServiceProvider serviceProvider, EndpointDefinition ... endpointDefinitions) {
        super(serviceProvider, endpointDefinitions);
    }

    public ScimResponse handleRequest(String requestUrl, HttpMethod httpMethod, String requestBody, Map<String, String> httpHeaders) {
        return this.handleRequest(requestUrl, httpMethod, requestBody, httpHeaders, null, null, null);
    }

    public ScimResponse handleRequest(String requestUrl, HttpMethod httpMethod, String requestBody, Map<String, String> httpHeaders, Context context) {
        return this.handleRequest(requestUrl, httpMethod, requestBody, httpHeaders, null, null, context);
    }

    public ScimResponse handleRequest(String requestUrl, HttpMethod httpMethod, String requestBody, Map<String, String> httpHeaders, Consumer<ResourceType> doBeforeExecution, Context context) {
        return this.handleRequest(requestUrl, httpMethod, requestBody, httpHeaders, doBeforeExecution, null, context);
    }

    public ScimResponse handleRequest(String requestUrl, HttpMethod httpMethod, String requestBody, Map<String, String> httpHeaders, BiConsumer<ScimResponse, Boolean> doAfterExecution, Context context) {
        return this.handleRequest(requestUrl, httpMethod, requestBody, httpHeaders, null, doAfterExecution, context);
    }

    public ScimResponse handleRequest(String requestUrl, HttpMethod httpMethod, String requestBody, Map<String, String> httpHeaders, Consumer<ResourceType> doBeforeExecution, BiConsumer<ScimResponse, Boolean> doAfterExecution, Context context) {
        ErrorResponse scimResponse;
        try {
            UriInfos uriInfos = UriInfos.getRequestUrlInfos(this.getResourceTypeFactory(), requestUrl, httpMethod, httpHeaders);
            if ("/Bulk".equals(uriInfos.getResourceEndpoint())) {
                BulkEndpoint bulkEndpoint = new BulkEndpoint(this, this.getServiceProvider(), this.getResourceTypeFactory(), uriInfos.getHttpHeaders(), uriInfos.getQueryParameters(), doBeforeExecution);
                scimResponse = bulkEndpoint.bulk(uriInfos.getBaseUri(), requestBody, context);
            } else {
                scimResponse = this.resolveRequest(httpMethod, requestBody, uriInfos, doBeforeExecution, context);
            }
        }
        catch (ScimException ex) {
            scimResponse = new ErrorResponse(ex);
        }
        catch (Exception ex) {
            scimResponse = new ErrorResponse((ScimException)new InternalServerException(ex.getMessage(), (Throwable)ex, null));
        }
        if (doAfterExecution != null) {
            doAfterExecution.accept((ScimResponse)scimResponse, this.isErrorResponse((ScimResponse)scimResponse));
        }
        return scimResponse;
    }

    protected ScimResponse resolveRequest(HttpMethod httpMethod, String requestBody, UriInfos uriInfos, Consumer<ResourceType> doBeforeExecution, Context context) {
        Optional.ofNullable(doBeforeExecution).ifPresent(consumer -> consumer.accept(uriInfos.getResourceType()));
        Context effectiveContext = this.getEffectiveContext(uriInfos, context);
        this.authenticateClient(uriInfos, effectiveContext.getAuthorization());
        switch (httpMethod) {
            case POST: {
                if (uriInfos.isSearchRequest()) {
                    EndpointFeatureHandler.handleEndpointFeatures(uriInfos.getResourceType(), EndpointType.LIST, effectiveContext.getAuthorization());
                    return this.listResources(uriInfos.getResourceEndpoint(), requestBody, uriInfos::getBaseUri, effectiveContext);
                }
                EndpointFeatureHandler.handleEndpointFeatures(uriInfos.getResourceType(), EndpointType.CREATE, effectiveContext.getAuthorization());
                return this.createResource(uriInfos.getResourceEndpoint(), requestBody, uriInfos::getBaseUri, effectiveContext);
            }
            case GET: {
                if (uriInfos.isSearchRequest() && !uriInfos.getResourceType().getFeatures().isSingletonEndpoint()) {
                    EndpointFeatureHandler.handleEndpointFeatures(uriInfos.getResourceType(), EndpointType.LIST, effectiveContext.getAuthorization());
                    String startIndex = uriInfos.getQueryParameters().get("startIndex".toLowerCase());
                    String count = uriInfos.getQueryParameters().get("count");
                    return this.listResources(uriInfos.getResourceEndpoint(), RequestUtils.parseStartIndex(startIndex).orElse(null), RequestUtils.parseCount(count).orElse(null), uriInfos.getQueryParameters().get("filter"), uriInfos.getQueryParameters().get("sortBy".toLowerCase()), uriInfos.getQueryParameters().get("sortOrder".toLowerCase()), uriInfos.getQueryParameters().get("attributes"), uriInfos.getQueryParameters().get("excludedAttributes".toLowerCase()), uriInfos::getBaseUri, effectiveContext);
                }
                EndpointFeatureHandler.handleEndpointFeatures(uriInfos.getResourceType(), EndpointType.GET, effectiveContext.getAuthorization());
                return this.getResource(uriInfos.getResourceEndpoint(), uriInfos.getResourceId(), uriInfos.getQueryParameters().get("attributes"), uriInfos.getQueryParameters().get("excludedAttributes".toLowerCase()), uriInfos.getHttpHeaders(), uriInfos::getBaseUri, effectiveContext);
            }
            case PUT: {
                EndpointFeatureHandler.handleEndpointFeatures(uriInfos.getResourceType(), EndpointType.UPDATE, effectiveContext.getAuthorization());
                return this.updateResource(uriInfos.getResourceEndpoint(), uriInfos.getResourceId(), requestBody, uriInfos.getHttpHeaders(), uriInfos::getBaseUri, effectiveContext);
            }
            case PATCH: {
                EndpointFeatureHandler.handleEndpointFeatures(uriInfos.getResourceType(), EndpointType.UPDATE, effectiveContext.getAuthorization());
                return this.patchResource(uriInfos.getResourceEndpoint(), uriInfos.getResourceId(), requestBody, uriInfos.getQueryParameters().get("attributes"), uriInfos.getQueryParameters().get("excludedAttributes".toLowerCase()), uriInfos.getHttpHeaders(), uriInfos::getBaseUri, effectiveContext);
            }
        }
        EndpointFeatureHandler.handleEndpointFeatures(uriInfos.getResourceType(), EndpointType.DELETE, effectiveContext.getAuthorization());
        return this.deleteResource(uriInfos.getResourceEndpoint(), uriInfos.getResourceId(), uriInfos.getHttpHeaders(), effectiveContext);
    }

    private Context getEffectiveContext(UriInfos uriInfos, Context context) {
        Context effectiveContext = Optional.ofNullable(context).orElse(new Context());
        effectiveContext.setResourceReferenceUrl(id -> super.getReferenceUrlSupplier(uriInfos::getBaseUri).apply(uriInfos.getResourceType().getName(), (String)id));
        effectiveContext.setCrossResourceReferenceUrl((resourceName, id) -> super.getReferenceUrlSupplier(uriInfos::getBaseUri).apply((String)id, (String)resourceName));
        return effectiveContext;
    }

    private boolean isErrorResponse(ScimResponse scimResponse) {
        return ErrorResponse.class.isAssignableFrom(scimResponse.getClass()) || BulkResponse.class.isAssignableFrom(scimResponse.getClass()) && scimResponse.getHttpStatus() != 200;
    }

    private void authenticateClient(UriInfos uriInfos, Authorization authorization) {
        ResourceType resourceType = uriInfos.getResourceType();
        if (!resourceType.getFeatures().getAuthorization().isAuthenticated()) {
            return;
        }
        if (authorization == null) {
            log.warn("Endpoint '{}' requires authentication but received no '{}' implementation. Authentication and Authorization will be bypassed.", (Object)uriInfos.getResourceEndpoint(), (Object)Authorization.class.getName());
        } else {
            boolean isAuthenticated = authorization.authenticate(uriInfos.getHttpHeaders(), uriInfos.getQueryParameters());
            if (!isAuthenticated) {
                log.debug("Authentication has failed");
                throw new UnauthenticatedException("not authenticated", this.getServiceProvider().getAuthenticationSchemes(), authorization.getRealm());
            }
        }
    }
}

