/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.common.response;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.common.response.BulkResponseOperation;
import de.captaingoldfish.scim.sdk.common.response.ScimResponse;
import java.util.Collections;
import java.util.List;

public class BulkResponse
extends ScimResponse {
    private int httpStatus;

    public BulkResponse(List<BulkResponseOperation> bulkResponseOperation, int httpStatus) {
        this();
        this.setBulkResponseOperations(bulkResponseOperation);
        this.httpStatus = httpStatus;
    }

    public BulkResponse() {
        super((JsonNode)null);
        this.setSchemas(Collections.singletonList("urn:ietf:params:scim:api:messages:2.0:BulkResponse"));
    }

    @Override
    public int getHttpStatus() {
        return this.httpStatus;
    }

    public List<BulkResponseOperation> getBulkResponseOperations() {
        List<BulkResponseOperation> operations = this.getArrayAttribute("Operations", BulkResponseOperation.class);
        if (operations.isEmpty()) {
            this.setAttribute("Operations", operations);
        }
        return operations;
    }

    public void setBulkResponseOperations(List<BulkResponseOperation> bulkRequestOperations) {
        this.setAttribute("Operations", bulkRequestOperations);
    }

    public static BulkResponseBuilder builder() {
        return new BulkResponseBuilder();
    }

    public static class BulkResponseBuilder {
        private List<BulkResponseOperation> bulkResponseOperation;
        private int httpStatus;

        BulkResponseBuilder() {
        }

        public BulkResponseBuilder bulkResponseOperation(List<BulkResponseOperation> bulkResponseOperation) {
            this.bulkResponseOperation = bulkResponseOperation;
            return this;
        }

        public BulkResponseBuilder httpStatus(int httpStatus) {
            this.httpStatus = httpStatus;
            return this;
        }

        public BulkResponse build() {
            return new BulkResponse(this.bulkResponseOperation, this.httpStatus);
        }

        public String toString() {
            return "BulkResponse.BulkResponseBuilder(bulkResponseOperation=" + this.bulkResponseOperation + ", httpStatus=" + this.httpStatus + ")";
        }
    }
}

