/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.common.resources.complex;

import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import java.util.Optional;

public class BulkConfig
extends ScimObjectNode {
    protected static final Integer DEFAULT_MAX_OPERATIONS = 1;
    protected static final Long DEFAULT_MAX_PAYLOAD_SIZE = (long)(Math.pow(1024.0, 2.0) * 2.0);

    public BulkConfig(Boolean supported, Integer maxOperations, Long maxPayloadSize) {
        super(null);
        this.setSupported(supported);
        this.setMaxOperations(maxOperations);
        this.setMaxPayloadSize(maxPayloadSize);
    }

    public boolean isSupported() {
        return this.getBooleanAttribute("supported").orElse(false);
    }

    public void setSupported(Boolean supported) {
        this.setAttribute("supported", Optional.ofNullable(supported).orElse(false));
    }

    public Integer getMaxOperations() {
        return this.getLongAttribute("maxOperations").orElse((long)DEFAULT_MAX_OPERATIONS).intValue();
    }

    public void setMaxOperations(Integer maxOperations) {
        Long max = maxOperations == null ? null : Long.valueOf(maxOperations.intValue());
        this.setAttribute("maxOperations", Optional.ofNullable(max).orElse((long)DEFAULT_MAX_OPERATIONS));
    }

    public Long getMaxPayloadSize() {
        return this.getLongAttribute("maxPayloadSize").orElse(DEFAULT_MAX_PAYLOAD_SIZE);
    }

    public void setMaxPayloadSize(Long maxPayloadSize) {
        this.setAttribute("maxPayloadSize", Optional.ofNullable(maxPayloadSize).orElse(DEFAULT_MAX_PAYLOAD_SIZE));
    }

    public static BulkConfigBuilder builder() {
        return new BulkConfigBuilder();
    }

    public BulkConfig() {
    }

    public static class BulkConfigBuilder {
        private Boolean supported;
        private Integer maxOperations;
        private Long maxPayloadSize;

        BulkConfigBuilder() {
        }

        public BulkConfigBuilder supported(Boolean supported) {
            this.supported = supported;
            return this;
        }

        public BulkConfigBuilder maxOperations(Integer maxOperations) {
            this.maxOperations = maxOperations;
            return this;
        }

        public BulkConfigBuilder maxPayloadSize(Long maxPayloadSize) {
            this.maxPayloadSize = maxPayloadSize;
            return this;
        }

        public BulkConfig build() {
            return new BulkConfig(this.supported, this.maxOperations, this.maxPayloadSize);
        }

        public String toString() {
            return "BulkConfig.BulkConfigBuilder(supported=" + this.supported + ", maxOperations=" + this.maxOperations + ", maxPayloadSize=" + this.maxPayloadSize + ")";
        }
    }
}

