/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.common.resources;

import de.captaingoldfish.scim.sdk.common.resources.EnterpriseUser;
import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;
import de.captaingoldfish.scim.sdk.common.resources.complex.Meta;
import de.captaingoldfish.scim.sdk.common.resources.complex.Name;
import de.captaingoldfish.scim.sdk.common.resources.multicomplex.Address;
import de.captaingoldfish.scim.sdk.common.resources.multicomplex.Email;
import de.captaingoldfish.scim.sdk.common.resources.multicomplex.Entitlement;
import de.captaingoldfish.scim.sdk.common.resources.multicomplex.GroupNode;
import de.captaingoldfish.scim.sdk.common.resources.multicomplex.Ims;
import de.captaingoldfish.scim.sdk.common.resources.multicomplex.PersonRole;
import de.captaingoldfish.scim.sdk.common.resources.multicomplex.PhoneNumber;
import de.captaingoldfish.scim.sdk.common.resources.multicomplex.Photo;
import de.captaingoldfish.scim.sdk.common.resources.multicomplex.ScimX509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class User
extends ResourceNode {
    public User() {
        this.setSchemas(Arrays.asList("urn:ietf:params:scim:schemas:core:2.0:User"));
    }

    private User(String id, String externalId, Meta meta, String userName, Name name, String displayName, String nickName, String profileUrl, String title, String userType, String preferredLanguage, String locale, String timeZone, Boolean active, String password, List<Email> emails, List<PhoneNumber> phoneNumbers, List<Ims> ims, List<Photo> photos, List<Address> addresses, List<GroupNode> groups, List<Entitlement> entitlements, List<PersonRole> roles, List<ScimX509Certificate> x509Certificates, EnterpriseUser enterpriseUser) {
        this();
        this.setId(id);
        this.setExternalId(externalId);
        this.setMeta(meta);
        this.setUserName(userName);
        this.setName(name);
        this.setDisplayName(displayName);
        this.setNickName(nickName);
        this.setProfileUrl(profileUrl);
        this.setTitle(title);
        this.setUserType(userType);
        this.setPreferredLanguage(preferredLanguage);
        this.setLocale(locale);
        this.setTimezone(timeZone);
        this.setActive(active);
        this.setPassword(password);
        this.setEmails(emails);
        this.setPhoneNumbers(phoneNumbers);
        this.setIms(ims);
        this.setPhotos(photos);
        this.setAddresses(addresses);
        this.setGroups(groups);
        this.setEntitlements(entitlements);
        this.setRoles(roles);
        this.setX509Certificates(x509Certificates);
        this.setEnterpriseUser(enterpriseUser);
    }

    public Optional<String> getUserName() {
        return this.getStringAttribute("userName");
    }

    public void setUserName(String userName) {
        this.setAttribute("userName", userName);
    }

    public Optional<Name> getName() {
        return this.getObjectAttribute("name", Name.class);
    }

    public void setName(Name name) {
        this.setAttribute("name", name);
    }

    public Optional<String> getDisplayName() {
        return this.getStringAttribute("displayName");
    }

    public void setDisplayName(String displayName) {
        this.setAttribute("displayName", displayName);
    }

    public Optional<String> getNickName() {
        return this.getStringAttribute("nickName");
    }

    public void setNickName(String nickName) {
        this.setAttribute("nickName", nickName);
    }

    public Optional<String> getProfileUrl() {
        return this.getStringAttribute("profileUrl");
    }

    public void setProfileUrl(String profileUrl) {
        this.setAttribute("profileUrl", profileUrl);
    }

    public Optional<String> getTitle() {
        return this.getStringAttribute("title");
    }

    public void setTitle(String title) {
        this.setAttribute("title", title);
    }

    public Optional<String> getUserType() {
        return this.getStringAttribute("userType");
    }

    public void setUserType(String userType) {
        this.setAttribute("userType", userType);
    }

    public Optional<String> getPreferredLanguage() {
        return this.getStringAttribute("preferredLanguage");
    }

    public void setPreferredLanguage(String preferredLanguage) {
        this.setAttribute("preferredLanguage", preferredLanguage);
    }

    public Optional<String> getLocale() {
        return this.getStringAttribute("locale");
    }

    public void setLocale(String locale) {
        this.setAttribute("locale", locale);
    }

    public Optional<String> getTimezone() {
        return this.getStringAttribute("timezone");
    }

    public void setTimezone(String timezone) {
        this.setAttribute("timezone", timezone);
    }

    public Optional<Boolean> isActive() {
        return this.getBooleanAttribute("active");
    }

    public void setActive(Boolean active) {
        this.setAttribute("active", active);
    }

    public Optional<String> getPassword() {
        return this.getStringAttribute("password");
    }

    public void setPassword(String password) {
        this.setAttribute("password", password);
    }

    public List<Email> getEmails() {
        return this.getArrayAttribute("emails", Email.class);
    }

    public void setEmails(List<Email> emails) {
        this.setAttribute("emails", emails);
    }

    public void addEmail(Email email) {
        this.addAttribute("emails", email);
    }

    public List<PhoneNumber> getPhoneNumbers() {
        return this.getArrayAttribute("phoneNumbers", PhoneNumber.class);
    }

    public void setPhoneNumbers(List<PhoneNumber> phoneNumbers) {
        this.setAttribute("phoneNumbers", phoneNumbers);
    }

    public void addPhoneNumber(PhoneNumber phoneNumber) {
        this.addAttribute("phoneNumbers", phoneNumber);
    }

    public List<Ims> getIms() {
        return this.getArrayAttribute("ims", Ims.class);
    }

    public void setIms(List<Ims> ims) {
        this.setAttribute("ims", ims);
    }

    public void addIms(Ims ims) {
        this.addAttribute("ims", ims);
    }

    public List<Photo> getPhotos() {
        return this.getArrayAttribute("photos", Photo.class);
    }

    public void setPhotos(List<Photo> photos) {
        this.setAttribute("photos", photos);
    }

    public void addPhoto(Photo photo) {
        this.addAttribute("photos", photo);
    }

    public List<Address> getAddresses() {
        return this.getArrayAttribute("addresses", Address.class);
    }

    public void setAddresses(List<Address> addresses) {
        this.setAttribute("addresses", addresses);
    }

    public void addAddress(Address address) {
        this.addAttribute("addresses", address);
    }

    public List<GroupNode> getGroups() {
        return this.getArrayAttribute("groups", GroupNode.class);
    }

    public void setGroups(List<GroupNode> groups) {
        this.setAttribute("groups", groups);
    }

    public void addGroup(GroupNode group) {
        this.addAttribute("groups", group);
    }

    public List<Entitlement> getEntitlements() {
        return this.getArrayAttribute("entitlements", Entitlement.class);
    }

    public void setEntitlements(List<Entitlement> entitlements) {
        this.setAttribute("entitlements", entitlements);
    }

    public void addEntitlement(Entitlement entitlement) {
        this.addAttribute("entitlements", entitlement);
    }

    public List<PersonRole> getRoles() {
        return this.getArrayAttribute("roles", PersonRole.class);
    }

    public void setRoles(List<PersonRole> personRoles) {
        this.setAttribute("roles", personRoles);
    }

    public void addRole(PersonRole personRole) {
        this.addAttribute("roles", personRole);
    }

    public List<ScimX509Certificate> getX509Certificates() {
        return this.getArrayAttribute("x509Certificates", ScimX509Certificate.class);
    }

    public void setX509Certificates(List<ScimX509Certificate> x509Certificates) {
        this.setAttribute("x509Certificates", x509Certificates);
    }

    public void addX509Certificate(ScimX509Certificate x509Certificate) {
        this.addAttribute("x509Certificates", x509Certificate);
    }

    public Optional<EnterpriseUser> getEnterpriseUser() {
        return this.getObjectAttribute("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User", EnterpriseUser.class);
    }

    public void setEnterpriseUser(EnterpriseUser enterpriseUser) {
        Set<String> schemas = this.getSchemas();
        if (enterpriseUser == null || enterpriseUser.size() == 0) {
            schemas.remove("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User");
        } else if (!schemas.contains("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User")) {
            schemas.add("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User");
        }
        this.setSchemas(schemas);
        this.setAttribute("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User", enterpriseUser);
    }

    public static UserBuilder builder() {
        return new UserBuilder();
    }

    public static class UserBuilder {
        private String id;
        private String externalId;
        private Meta meta;
        private String userName;
        private Name name;
        private String displayName;
        private String nickName;
        private String profileUrl;
        private String title;
        private String userType;
        private String preferredLanguage;
        private String locale;
        private String timeZone;
        private Boolean active;
        private String password;
        private List<Email> emails;
        private List<PhoneNumber> phoneNumbers;
        private List<Ims> ims;
        private List<Photo> photos;
        private List<Address> addresses;
        private List<GroupNode> groups;
        private List<Entitlement> entitlements;
        private List<PersonRole> roles;
        private List<ScimX509Certificate> x509Certificates;
        private EnterpriseUser enterpriseUser;

        UserBuilder() {
        }

        public UserBuilder id(String id) {
            this.id = id;
            return this;
        }

        public UserBuilder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public UserBuilder meta(Meta meta) {
            this.meta = meta;
            return this;
        }

        public UserBuilder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public UserBuilder name(Name name) {
            this.name = name;
            return this;
        }

        public UserBuilder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public UserBuilder nickName(String nickName) {
            this.nickName = nickName;
            return this;
        }

        public UserBuilder profileUrl(String profileUrl) {
            this.profileUrl = profileUrl;
            return this;
        }

        public UserBuilder title(String title) {
            this.title = title;
            return this;
        }

        public UserBuilder userType(String userType) {
            this.userType = userType;
            return this;
        }

        public UserBuilder preferredLanguage(String preferredLanguage) {
            this.preferredLanguage = preferredLanguage;
            return this;
        }

        public UserBuilder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public UserBuilder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public UserBuilder active(Boolean active) {
            this.active = active;
            return this;
        }

        public UserBuilder password(String password) {
            this.password = password;
            return this;
        }

        public UserBuilder emails(List<Email> emails) {
            this.emails = emails;
            return this;
        }

        public UserBuilder phoneNumbers(List<PhoneNumber> phoneNumbers) {
            this.phoneNumbers = phoneNumbers;
            return this;
        }

        public UserBuilder ims(List<Ims> ims) {
            this.ims = ims;
            return this;
        }

        public UserBuilder photos(List<Photo> photos) {
            this.photos = photos;
            return this;
        }

        public UserBuilder addresses(List<Address> addresses) {
            this.addresses = addresses;
            return this;
        }

        public UserBuilder groups(List<GroupNode> groups) {
            this.groups = groups;
            return this;
        }

        public UserBuilder entitlements(List<Entitlement> entitlements) {
            this.entitlements = entitlements;
            return this;
        }

        public UserBuilder roles(List<PersonRole> roles) {
            this.roles = roles;
            return this;
        }

        public UserBuilder x509Certificates(List<ScimX509Certificate> x509Certificates) {
            this.x509Certificates = x509Certificates;
            return this;
        }

        public UserBuilder enterpriseUser(EnterpriseUser enterpriseUser) {
            this.enterpriseUser = enterpriseUser;
            return this;
        }

        public User build() {
            return new User(this.id, this.externalId, this.meta, this.userName, this.name, this.displayName, this.nickName, this.profileUrl, this.title, this.userType, this.preferredLanguage, this.locale, this.timeZone, this.active, this.password, this.emails, this.phoneNumbers, this.ims, this.photos, this.addresses, this.groups, this.entitlements, this.roles, this.x509Certificates, this.enterpriseUser);
        }

        public String toString() {
            return "User.UserBuilder(id=" + this.id + ", externalId=" + this.externalId + ", meta=" + this.meta + ", userName=" + this.userName + ", name=" + this.name + ", displayName=" + this.displayName + ", nickName=" + this.nickName + ", profileUrl=" + this.profileUrl + ", title=" + this.title + ", userType=" + this.userType + ", preferredLanguage=" + this.preferredLanguage + ", locale=" + this.locale + ", timeZone=" + this.timeZone + ", active=" + this.active + ", password=" + this.password + ", emails=" + this.emails + ", phoneNumbers=" + this.phoneNumbers + ", ims=" + this.ims + ", photos=" + this.photos + ", addresses=" + this.addresses + ", groups=" + this.groups + ", entitlements=" + this.entitlements + ", roles=" + this.roles + ", x509Certificates=" + this.x509Certificates + ", enterpriseUser=" + this.enterpriseUser + ")";
        }
    }
}

