/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.common.schemas;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import de.captaingoldfish.scim.sdk.common.exceptions.InvalidSchemaException;
import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;
import de.captaingoldfish.scim.sdk.common.resources.complex.Meta;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class Schema
extends ResourceNode {
    private Map<String, SchemaAttribute> attributeRegister = new HashMap<String, SchemaAttribute>();
    private List<SchemaAttribute> bulkIdCandidates = new ArrayList<SchemaAttribute>();

    public Schema(JsonNode jsonNode, String namePrefix) {
        this.setSchemas(JsonHelper.getSimpleAttributeArray(jsonNode, "schemas").orElse(Collections.emptyList()));
        String errorMessage = "attribute 'id' is missing cannot resolve schema";
        this.setId(JsonHelper.getSimpleAttribute(jsonNode, "id").orElseThrow(() -> new InvalidSchemaException(errorMessage, null, 500, null)));
        this.setName(JsonHelper.getSimpleAttribute(jsonNode, "name").orElse(null));
        this.setDescription(JsonHelper.getSimpleAttribute(jsonNode, "description").orElse(null));
        ArrayList<SchemaAttribute> attributeList = new ArrayList<SchemaAttribute>();
        String noAttributesErrorMessage = "schema with id '" + (String)this.getId().orElse(null) + "' does not have attributes";
        ArrayNode attributes = JsonHelper.getArrayAttribute(jsonNode, "attributes").orElseThrow(() -> new InvalidSchemaException(noAttributesErrorMessage, null, 500, null));
        HashSet<String> attributeNameSet = new HashSet<String>();
        for (JsonNode node : attributes) {
            SchemaAttribute schemaAttribute = new SchemaAttribute(this, this.getNonNullId(), null, node, namePrefix);
            if (attributeNameSet.contains(schemaAttribute.getName())) {
                String duplicateNameMessage = "the attribute with the name '" + schemaAttribute.getName() + "' was found twice within the given schema declaration";
                throw new InvalidSchemaException(duplicateNameMessage, null, null, null);
            }
            attributeNameSet.add(schemaAttribute.getName());
            attributeList.add(schemaAttribute);
        }
        this.setAttributes(attributeList);
        this.initMeta(jsonNode.get("meta"));
    }

    public Schema(JsonNode jsonNode) {
        this(jsonNode, null);
    }

    private void initMeta(JsonNode jsonNode) {
        Meta meta;
        if (jsonNode == null) {
            LocalDateTime now = LocalDateTime.now();
            meta = Meta.builder().created(now).lastModified(now).resourceType("Schema").build();
        } else {
            meta = JsonHelper.copyResourceToObject(jsonNode, Meta.class);
        }
        this.setMeta(meta);
    }

    public String getNonNullId() {
        String errorMessage = "attribute 'id' is missing cannot resolve schema";
        return this.getId().orElseThrow(() -> new InvalidSchemaException(errorMessage, null, 500, null));
    }

    public Optional<String> getName() {
        return this.getStringAttribute("name");
    }

    private void setName(String name) {
        this.setAttribute("name", name);
    }

    public Optional<String> getDescription() {
        return this.getStringAttribute("description");
    }

    private void setDescription(String description) {
        this.setAttribute("description", description);
    }

    public List<SchemaAttribute> getAttributes() {
        return super.getArrayAttribute("attributes", SchemaAttribute.class);
    }

    private void setAttributes(List<SchemaAttribute> attributes) {
        this.setAttribute("attributes", attributes);
    }

    public void addAttribute(JsonNode schemaAttribute) {
        List<SchemaAttribute> attributes = this.getAttributes();
        attributes.add(new SchemaAttribute(this, this.getNonNullId(), null, schemaAttribute));
        this.setAttributes(attributes);
    }

    public Set<String> getAttributeNames() {
        return this.getAttributes().stream().flatMap(attribute -> attribute.getSubAttributes().stream()).map(SchemaAttribute::getScimNodeName).collect(Collectors.toSet());
    }

    public void removeAttribute(SchemaAttribute schemaAttribute) {
        List<SchemaAttribute> attributes = this.getAttributes();
        this.attributeRegister.remove(schemaAttribute.getScimNodeName());
        attributes.remove(schemaAttribute);
        this.setAttributes(attributes);
    }

    public SchemaAttribute getSchemaAttribute(String scimNodeName) {
        return this.attributeRegister.get(StringUtils.stripToEmpty((String)scimNodeName).toLowerCase());
    }

    public void addSchemaAttribute(SchemaAttribute schemaAttribute) {
        String scimNodeName = schemaAttribute.getScimNodeName().toLowerCase();
        if (this.attributeRegister.containsKey(scimNodeName)) {
            throw new InvalidSchemaException("schema '" + this.getNonNullId() + "' has an duplicate attribute name: '" + scimNodeName + "'", null, null, null);
        }
        this.attributeRegister.put(scimNodeName, schemaAttribute);
    }

    public Map<String, SchemaAttribute> getAttributeRegister() {
        return this.attributeRegister;
    }

    public List<SchemaAttribute> getBulkIdCandidates() {
        return this.bulkIdCandidates;
    }
}

