/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.common.request;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.HttpMethod;
import de.captaingoldfish.scim.sdk.common.etag.ETag;
import de.captaingoldfish.scim.sdk.common.exceptions.BadRequestException;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class BulkRequestOperation
extends ScimObjectNode {
    protected static final List<HttpMethod> VALID_METHODS = Arrays.asList(HttpMethod.POST, HttpMethod.PUT, HttpMethod.PATCH, HttpMethod.DELETE);
    public String uniqueIdentifier;

    public BulkRequestOperation() {
        super(null);
    }

    public BulkRequestOperation(HttpMethod method, String bulkId, String path, String data, ETag version) {
        this();
        this.setMethod(method);
        this.setBulkId(bulkId);
        this.setPath(path);
        this.setData(data);
        this.setVersion(version);
    }

    public HttpMethod getMethod() {
        return this.getStringAttribute("method").map(HttpMethod::valueOf).orElseThrow(() -> new BadRequestException("the 'method' attribute is mandatory", null, "invalidParameters"));
    }

    public void setMethod(HttpMethod method) {
        if (method != null && !VALID_METHODS.contains((Object)method)) {
            throw new BadRequestException("bulk does only support the following methods '" + VALID_METHODS + "' but found method: " + (Object)((Object)method), null, "invalidParameters");
        }
        this.setAttribute("method", method == null ? null : method.name());
    }

    public Optional<String> getBulkId() {
        return this.getStringAttribute("bulkId");
    }

    public void setBulkId(String bulkId) {
        this.setAttribute("bulkId", bulkId);
    }

    public String getPath() {
        return this.getStringAttribute("path").orElseThrow(() -> new BadRequestException("the 'path' attribute is mandatory", null, null));
    }

    public void setPath(String path) {
        this.setAttribute("path", path);
    }

    public Optional<String> getData() {
        return Optional.ofNullable(this.get("data")).map(jsonNode -> jsonNode.isTextual() ? jsonNode.textValue() : jsonNode.toString());
    }

    public void setData(String data) {
        if (StringUtils.isBlank((CharSequence)data)) {
            return;
        }
        this.set("data", JsonHelper.readJsonDocument(data));
    }

    public Optional<ETag> getVersion() {
        return this.getStringAttribute("version", ETag.class);
    }

    public void setVersion(String version) {
        this.setVersion(ETag.builder().weak(true).tag(version).build());
    }

    public void setVersion(ETag version) {
        if (version == null) {
            this.remove("version");
        } else {
            this.set("version", (JsonNode)version);
        }
    }

    public static BulkRequestOperationBuilder builder() {
        return new BulkRequestOperationBuilder();
    }

    public String getUniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    public void setUniqueIdentifier(String uniqueIdentifier) {
        this.uniqueIdentifier = uniqueIdentifier;
    }

    public static class BulkRequestOperationBuilder {
        private HttpMethod method;
        private String bulkId;
        private String path;
        private String data;
        private ETag version;

        BulkRequestOperationBuilder() {
        }

        public BulkRequestOperationBuilder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        public BulkRequestOperationBuilder bulkId(String bulkId) {
            this.bulkId = bulkId;
            return this;
        }

        public BulkRequestOperationBuilder path(String path) {
            this.path = path;
            return this;
        }

        public BulkRequestOperationBuilder data(String data) {
            this.data = data;
            return this;
        }

        public BulkRequestOperationBuilder version(ETag version) {
            this.version = version;
            return this;
        }

        public BulkRequestOperation build() {
            return new BulkRequestOperation(this.method, this.bulkId, this.path, this.data, this.version);
        }

        public String toString() {
            return "BulkRequestOperation.BulkRequestOperationBuilder(method=" + (Object)((Object)this.method) + ", bulkId=" + this.bulkId + ", path=" + this.path + ", data=" + this.data + ", version=" + this.version + ")";
        }
    }
}

