/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.common.resources.complex;

import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import java.util.Optional;

public class FilterConfig
extends ScimObjectNode {
    protected static final Integer DEFAULT_MAX_RESULTS = 1;

    public FilterConfig(Boolean supported, Integer maxResults) {
        super(null);
        this.setSupported(supported);
        this.setMaxResults(maxResults);
    }

    public boolean isSupported() {
        return this.getBooleanAttribute("supported").orElse(false);
    }

    public void setSupported(Boolean supported) {
        this.setAttribute("supported", Optional.ofNullable(supported).orElse(false));
    }

    public Integer getMaxResults() {
        return this.getLongAttribute("maxResults").orElse((long)DEFAULT_MAX_RESULTS).intValue();
    }

    public void setMaxResults(Integer maxResults) {
        Long results = maxResults == null ? null : Long.valueOf(maxResults.intValue());
        this.setAttribute("maxResults", Optional.ofNullable(results).orElse((long)DEFAULT_MAX_RESULTS));
    }

    public static FilterConfigBuilder builder() {
        return new FilterConfigBuilder();
    }

    public static class FilterConfigBuilder {
        private Boolean supported;
        private Integer maxResults;

        FilterConfigBuilder() {
        }

        public FilterConfigBuilder supported(Boolean supported) {
            this.supported = supported;
            return this;
        }

        public FilterConfigBuilder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public FilterConfig build() {
            return new FilterConfig(this.supported, this.maxResults);
        }

        public String toString() {
            return "FilterConfig.FilterConfigBuilder(supported=" + this.supported + ", maxResults=" + this.maxResults + ")";
        }
    }
}

