/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.common.resources.complex;

import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterConfig
extends ScimObjectNode {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FilterConfig.class);
    protected static final Integer DEFAULT_MAX_RESULTS = 1;

    public FilterConfig() {
        this.setSupported(false);
    }

    public FilterConfig(Boolean supported, Integer maxResults) {
        super(null);
        this.setSupported(Optional.ofNullable(supported).orElse(false));
        this.setMaxResults(maxResults);
    }

    public boolean isSupported() {
        return this.getBooleanAttribute("supported").orElse(false);
    }

    public void setSupported(Boolean supported) {
        this.setAttribute("supported", Optional.ofNullable(supported).orElse(false));
    }

    public Integer getMaxResults() {
        return this.getLongAttribute("maxResults").orElse((long)DEFAULT_MAX_RESULTS).intValue();
    }

    public void setMaxResults(Integer maxResults) {
        Long results = maxResults == null ? null : Long.valueOf(maxResults.intValue());
        this.setAttribute("maxResults", Optional.ofNullable(results).orElseGet(() -> {
            log.warn("No value set for 'FilterConfig.maxResults'. Value is defaulting to: {}", (Object)DEFAULT_MAX_RESULTS);
            return (long)DEFAULT_MAX_RESULTS;
        }));
    }

    @Generated
    public static FilterConfigBuilder builder() {
        return new FilterConfigBuilder();
    }

    public static class FilterConfigBuilder {
        @Generated
        private Boolean supported;
        @Generated
        private Integer maxResults;

        @Generated
        public FilterConfigBuilder supported(Boolean supported) {
            this.supported = supported;
            return this;
        }

        @Generated
        public FilterConfigBuilder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Generated
        public FilterConfig build() {
            return new FilterConfig(this.supported, this.maxResults);
        }

        @Generated
        public String toString() {
            return "FilterConfig.FilterConfigBuilder(supported=" + this.supported + ", maxResults=" + this.maxResults + ")";
        }
    }
}

