/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.common.request;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.TextNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.PatchOp;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class PatchRequestOperation
extends ScimObjectNode {
    private boolean valueExtracted = false;

    public PatchRequestOperation(String path, PatchOp op, List<String> values, JsonNode valueNode) {
        this();
        this.setPath(path);
        this.setOp(op);
        if (values == null || values.isEmpty()) {
            this.setValueNode(valueNode);
        } else {
            this.setValues(values);
        }
    }

    public Optional<String> getPath() {
        return this.getStringAttribute("path");
    }

    public void setPath(String path) {
        this.setAttribute("path", path);
    }

    public PatchOp getOp() {
        return this.getStringAttribute("op").map(PatchOp::getByValue).orElse(null);
    }

    public void setOp(PatchOp patchOp) {
        this.setAttribute("op", patchOp == null ? null : patchOp.getValue());
    }

    public Optional<JsonNode> getValue() {
        JsonNode valueNode = this.get("value");
        if (valueNode == null || valueNode.isNull()) {
            return Optional.empty();
        }
        if (this.valueExtracted) {
            return Optional.of(valueNode);
        }
        if (valueNode.isObject() || valueNode.isArray()) {
            this.valueExtracted = true;
            return Optional.of(valueNode);
        }
        String textValue = valueNode.asText();
        if (valueNode instanceof TextNode && textValue.contains("{")) {
            try {
                valueNode = JsonHelper.readJsonDocument(textValue);
                this.setValue(valueNode);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.valueExtracted = true;
        return Optional.of(valueNode);
    }

    public void setValue(String value) {
        this.valueExtracted = false;
        this.setAttribute("value", value);
    }

    public void setValue(JsonNode value) {
        this.valueExtracted = false;
        this.set("value", value);
    }

    public List<String> getValues() {
        return this.getSimpleArrayAttribute("value");
    }

    public void setValues(List<String> value) {
        this.valueExtracted = false;
        if (value == null || value.size() > 1) {
            this.setAttributeList("value", value);
        } else if (value.size() == 1) {
            this.setAttribute("value", value.get(0));
        } else {
            this.setAttribute("value", (String)null);
        }
    }

    public Optional<ArrayNode> getValueNode() {
        JsonNode jsonNode = this.get("value");
        if (jsonNode == null || jsonNode.isNull()) {
            return Optional.empty();
        }
        if (jsonNode.isArray()) {
            return Optional.of((ArrayNode)jsonNode);
        }
        if (jsonNode instanceof TextNode) {
            ArrayNode arrayNode = new ArrayNode(JsonNodeFactory.instance);
            try {
                JsonNode jsonValue = JsonHelper.readJsonDocument(jsonNode.textValue());
                arrayNode.add(jsonValue);
            }
            catch (Exception ex) {
                arrayNode.add(jsonNode.textValue());
            }
            this.setValueNode((JsonNode)arrayNode);
            return Optional.of(arrayNode);
        }
        ArrayNode arrayNode = new ArrayNode(JsonNodeFactory.instance);
        arrayNode.add(jsonNode);
        this.setValueNode((JsonNode)arrayNode);
        return Optional.of(arrayNode);
    }

    public void setValueNode(JsonNode value) {
        this.setAttribute("value", value == null ? null : Collections.singletonList(value));
    }

    @Generated
    public static PatchRequestOperationBuilder builder() {
        return new PatchRequestOperationBuilder();
    }

    @Generated
    public PatchRequestOperation() {
    }

    public static class PatchRequestOperationBuilder {
        @Generated
        private String path;
        @Generated
        private PatchOp op;
        @Generated
        private List<String> values;
        @Generated
        private JsonNode valueNode;

        public PatchRequestOperationBuilder value(String value) {
            this.values(Arrays.asList(value));
            return this;
        }

        @Generated
        public PatchRequestOperationBuilder path(String path) {
            this.path = path;
            return this;
        }

        @Generated
        public PatchRequestOperationBuilder op(PatchOp op) {
            this.op = op;
            return this;
        }

        @Generated
        public PatchRequestOperationBuilder values(List<String> values) {
            this.values = values;
            return this;
        }

        @Generated
        public PatchRequestOperationBuilder valueNode(JsonNode valueNode) {
            this.valueNode = valueNode;
            return this;
        }

        @Generated
        public PatchRequestOperation build() {
            return new PatchRequestOperation(this.path, this.op, this.values, this.valueNode);
        }

        @Generated
        public String toString() {
            return "PatchRequestOperation.PatchRequestOperationBuilder(path=" + this.path + ", op=" + (Object)((Object)this.op) + ", values=" + this.values + ", valueNode=" + this.valueNode + ")";
        }
    }
}

