// Generated by delombok at Wed Mar 06 18:33:38 CET 2024
package de.captaingoldfish.scim.sdk.common.resources.complex;

import java.util.Optional;
import de.captaingoldfish.scim.sdk.common.constants.AttributeNames;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;


/**
 * author Pascal Knueppel <br>
 * created at: 18.10.2019 - 11:12 <br>
 * <br>
 * A complex type that specifies PATCH configuration options. REQUIRED. See Section 3.5.2 of [RFC7644].
 */
public class PatchConfig extends ScimObjectNode
{

  public PatchConfig()
  {
    setSupported(false);
  }

  public PatchConfig(Boolean supported,
                     Boolean ignoreUnknownAttributes,
                     Boolean doNotFailOnNoTarget,
                     Boolean activateSailsPointWorkaround,
                     Boolean activateMsAzureWorkaround,
                     Boolean activateMsAzureValueSubAttributeWorkaround,
                     Boolean msAzureComplexSimpleValueWorkaroundActive)
  {
    super(null);
    setSupported(Optional.ofNullable(supported).orElse(false));
    setIgnoreUnknownAttribute(ignoreUnknownAttributes);
    setDoNotFailOnNoTarget(doNotFailOnNoTarget);
    setActivateSailsPointWorkaround(activateSailsPointWorkaround);
    setMsAzureFilterWorkaroundActive(activateMsAzureWorkaround);
    setMsAzureValueSubAttributeWorkaroundActive(activateMsAzureValueSubAttributeWorkaround);
    setMsAzureComplexSimpleValueWorkaroundActive(msAzureComplexSimpleValueWorkaroundActive);
  }

  /**
   * A Boolean value specifying whether the operation is supported. REQUIRED.
   */
  public boolean isSupported()
  {
    return getBooleanAttribute(AttributeNames.RFC7643.SUPPORTED).orElse(false);
  }

  /**
   * A Boolean value specifying whether the operation is supported. REQUIRED.
   */
  public void setSupported(Boolean supported)
  {
    setAttribute(AttributeNames.RFC7643.SUPPORTED, Optional.ofNullable(supported).orElse(false));
  }

  /**
   * If activated unknown attributes on patch expressions will no longer result in a BadRequestException.
   *
   * @see https://github.com/Captain-P-Goldfish/SCIM-SDK/issues/539
   */
  public boolean isIgnoreUnknownAttribute()
  {
    return getBooleanAttribute(AttributeNames.Custom.IGNORE_UNKNOWN_ATTRIBUTES).orElse(false);
  }

  /**
   * If activated unknown attributes on patch expressions will no longer result in a BadRequestException.
   *
   * @see https://github.com/Captain-P-Goldfish/SCIM-SDK/issues/539
   */
  public void setIgnoreUnknownAttribute(Boolean ignoreUnknownAttribute)
  {
    setAttribute(AttributeNames.Custom.IGNORE_UNKNOWN_ATTRIBUTES, ignoreUnknownAttribute);
  }

  /**
   * prevents that a patch-operation fails if the target of the attributes pointer is missing. In this case the
   * operation is simply ignored.
   */
  public boolean isDoNotFailOnNoTarget()
  {
    return getBooleanAttribute(AttributeNames.Custom.DO_NOT_FAIL_ON_NO_TARGET).orElse(false);
  }

  /**
   * prevents that a patch-operation fails if the target of the attributes pointer is missing. In this case the
   * operation is simply ignored.
   */
  public void setDoNotFailOnNoTarget(Boolean doNotFailOnNoTarget)
  {
    setAttribute(AttributeNames.Custom.DO_NOT_FAIL_ON_NO_TARGET, doNotFailOnNoTarget);
  }

  /**
   * A Workaround to handle patch replace-ops on single complex types as add operations.
   *
   * @see https://github.com/Captain-P-Goldfish/SCIM-SDK/issues/327
   */
  public boolean isActivateSailsPointWorkaround()
  {
    return getBooleanAttribute(AttributeNames.Custom.ACTIVATE_SAILS_POINT_WORKAROUND).orElse(false);
  }

  /**
   * A Workaround to handle patch replace-ops on single complex types as add operations.
   *
   * @see https://github.com/Captain-P-Goldfish/SCIM-SDK/issues/327
   */
  public void setActivateSailsPointWorkaround(Boolean activateSailsPointWorkaround)
  {
    setAttribute(AttributeNames.Custom.ACTIVATE_SAILS_POINT_WORKAROUND, activateSailsPointWorkaround);
  }

  /**
   * A workaround to handle filter-expressions in patch-paths as attributes that will be added to the resource
   *
   * @see https://github.com/Captain-P-Goldfish/SCIM-SDK/issues/416
   * @see de.captaingoldfish.scim.sdk.server.patch.workarounds.msazure.MsAzurePatchFilterWorkaround
   */
  public boolean isMsAzureFilterWorkaroundActive()
  {
    return getBooleanAttribute(AttributeNames.Custom.ACTIVATE_MS_AZURE_FILTER_WORKAROUND).orElse(false);
  }

  /**
   * A workaround to handle filter-expressions in patch-paths as attributes that will be added to the resource
   *
   * @see https://github.com/Captain-P-Goldfish/SCIM-SDK/issues/416
   * @see de.captaingoldfish.scim.sdk.server.patch.workarounds.msazure.MsAzurePatchFilterWorkaround
   */
  public void setMsAzureFilterWorkaroundActive(Boolean msAzureWorkaroundActive)
  {
    setAttribute(AttributeNames.Custom.ACTIVATE_MS_AZURE_FILTER_WORKAROUND, msAzureWorkaroundActive);
  }

  /**
   * A workaround to handle MsAzures illegal value-subattribute notation
   *
   * @see https://github.com/Captain-P-Goldfish/SCIM-SDK/issues/516
   * @see de.captaingoldfish.scim.sdk.server.patch.workarounds.msazure.MsAzurePatchValueSubAttributeRebuilder
   */
  public boolean isMsAzureValueSubAttributeWorkaroundActive()
  {
    return getBooleanAttribute(AttributeNames.Custom.ACTIVATE_MS_AZURE_VALUE_SUB_ATTRIBUTE_WORKAROUND).orElse(false);
  }

  /**
   * A workaround to handle MsAzures illegal value-subattribute notation
   *
   * @see https://github.com/Captain-P-Goldfish/SCIM-SDK/issues/516
   * @see de.captaingoldfish.scim.sdk.server.patch.workarounds.msazure.MsAzurePatchValueSubAttributeRebuilder
   */
  public void setMsAzureValueSubAttributeWorkaroundActive(Boolean msAzureValueSubAttributeWorkaroundActive)
  {
    setAttribute(AttributeNames.Custom.ACTIVATE_MS_AZURE_VALUE_SUB_ATTRIBUTE_WORKAROUND,
                 msAzureValueSubAttributeWorkaroundActive);
  }

  /**
   * A workaround to handle MsAzures illegal complex-simple-value notation.
   *
   * @see https://github.com/Captain-P-Goldfish/SCIM-SDK/issues/541
   * @see de.captaingoldfish.scim.sdk.server.patch.workarounds.msazure.MsAzurePatchComplexValueRebuilder
   */
  public boolean isMsAzureComplexSimpleValueWorkaroundActive()
  {
    return getBooleanAttribute(AttributeNames.Custom.ACTIVATE_MS_AZURE_COMPLEX_SIMPLE_VALUE_WORKAROUND).orElse(false);
  }

  /**
   * A workaround to handle MsAzures illegal complex-simple-value notation.
   *
   * @see https://github.com/Captain-P-Goldfish/SCIM-SDK/issues/541
   * @see de.captaingoldfish.scim.sdk.server.patch.workarounds.msazure.MsAzurePatchComplexValueRebuilder
   */
  public void setMsAzureComplexSimpleValueWorkaroundActive(Boolean msAzureComplexSimpleValueWorkaroundActive)
  {
    setAttribute(AttributeNames.Custom.ACTIVATE_MS_AZURE_COMPLEX_SIMPLE_VALUE_WORKAROUND,
                 msAzureComplexSimpleValueWorkaroundActive);
  }


  /**
   * override lombok builder with public constructor
   */
  public static class PatchConfigBuilder
  {

    @java.lang.SuppressWarnings("all")
    private Boolean supported;

    @java.lang.SuppressWarnings("all")
    private Boolean ignoreUnknownAttributes;

    @java.lang.SuppressWarnings("all")
    private Boolean doNotFailOnNoTarget;

    @java.lang.SuppressWarnings("all")
    private Boolean activateSailsPointWorkaround;

    @java.lang.SuppressWarnings("all")
    private Boolean activateMsAzureWorkaround;

    @java.lang.SuppressWarnings("all")
    private Boolean activateMsAzureValueSubAttributeWorkaround;

    @java.lang.SuppressWarnings("all")
    private Boolean msAzureComplexSimpleValueWorkaroundActive;

    public PatchConfigBuilder()
    {}

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public PatchConfig.PatchConfigBuilder supported(final Boolean supported)
    {
      this.supported = supported;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public PatchConfig.PatchConfigBuilder ignoreUnknownAttributes(final Boolean ignoreUnknownAttributes)
    {
      this.ignoreUnknownAttributes = ignoreUnknownAttributes;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public PatchConfig.PatchConfigBuilder doNotFailOnNoTarget(final Boolean doNotFailOnNoTarget)
    {
      this.doNotFailOnNoTarget = doNotFailOnNoTarget;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public PatchConfig.PatchConfigBuilder activateSailsPointWorkaround(final Boolean activateSailsPointWorkaround)
    {
      this.activateSailsPointWorkaround = activateSailsPointWorkaround;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public PatchConfig.PatchConfigBuilder activateMsAzureWorkaround(final Boolean activateMsAzureWorkaround)
    {
      this.activateMsAzureWorkaround = activateMsAzureWorkaround;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public PatchConfig.PatchConfigBuilder activateMsAzureValueSubAttributeWorkaround(final Boolean activateMsAzureValueSubAttributeWorkaround)
    {
      this.activateMsAzureValueSubAttributeWorkaround = activateMsAzureValueSubAttributeWorkaround;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public PatchConfig.PatchConfigBuilder msAzureComplexSimpleValueWorkaroundActive(final Boolean msAzureComplexSimpleValueWorkaroundActive)
    {
      this.msAzureComplexSimpleValueWorkaroundActive = msAzureComplexSimpleValueWorkaroundActive;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public PatchConfig build()
    {
      return new PatchConfig(this.supported, this.ignoreUnknownAttributes, this.doNotFailOnNoTarget,
                             this.activateSailsPointWorkaround, this.activateMsAzureWorkaround,
                             this.activateMsAzureValueSubAttributeWorkaround,
                             this.msAzureComplexSimpleValueWorkaroundActive);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString()
    {
      return "PatchConfig.PatchConfigBuilder(supported=" + this.supported + ", ignoreUnknownAttributes="
             + this.ignoreUnknownAttributes + ", doNotFailOnNoTarget=" + this.doNotFailOnNoTarget
             + ", activateSailsPointWorkaround=" + this.activateSailsPointWorkaround + ", activateMsAzureWorkaround="
             + this.activateMsAzureWorkaround + ", activateMsAzureValueSubAttributeWorkaround="
             + this.activateMsAzureValueSubAttributeWorkaround + ", msAzureComplexSimpleValueWorkaroundActive="
             + this.msAzureComplexSimpleValueWorkaroundActive + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  public static PatchConfig.PatchConfigBuilder builder()
  {
    return new PatchConfig.PatchConfigBuilder();
  }
}
