// Generated by delombok at Wed Mar 06 18:33:38 CET 2024
package de.captaingoldfish.scim.sdk.common.resources.complex;

import java.util.Optional;
import de.captaingoldfish.scim.sdk.common.constants.AttributeNames;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;


/**
 * author Pascal Knueppel <br>
 * created at: 11.10.2019 - 12:36 <br>
 * <br>
 * The user's manager. A complex type that optionally allows service providers to represent organizational
 * hierarchy by referencing the "id" attribute of another User.
 */
public class Manager extends ScimObjectNode
{

  public Manager()
  {
    super(null);
  }

  public Manager(String value, String displayName, String ref)
  {
    this();
    setValue(value);
    setDisplayName(displayName);
    setRef(ref);
  }

  /**
   * The displayName of the user's manager. This attribute is OPTIONAL, and mutability is "readOnly".
   */
  public Optional<String> getDisplayName()
  {
    return getStringAttribute(AttributeNames.RFC7643.DISPLAY_NAME);
  }

  /**
   * The displayName of the user's manager. This attribute is OPTIONAL, and mutability is "readOnly".
   */
  public void setDisplayName(String displayName)
  {
    setAttribute(AttributeNames.RFC7643.DISPLAY_NAME, displayName);
  }

  /**
   * The "id" of the SCIM resource representing the user's manager. RECOMMENDED.
   */
  public Optional<String> getValue()
  {
    return getStringAttribute(AttributeNames.RFC7643.VALUE);
  }

  /**
   * The "id" of the SCIM resource representing the user's manager. RECOMMENDED.
   */
  public void setValue(String value)
  {
    setAttribute(AttributeNames.RFC7643.VALUE, value);
  }

  /**
   * $ref The URI of the SCIM resource representing the User's manager. RECOMMENDED.
   */
  public Optional<String> getRef()
  {
    return getStringAttribute(AttributeNames.RFC7643.REF);
  }

  /**
   * $ref The URI of the SCIM resource representing the User's manager. RECOMMENDED.
   */
  public void setRef(String ref)
  {
    setAttribute(AttributeNames.RFC7643.REF, ref);
  }


  /**
   * override lombok builder with public constructor
   */
  public static class ManagerBuilder
  {

    @java.lang.SuppressWarnings("all")
    private String value;

    @java.lang.SuppressWarnings("all")
    private String displayName;

    @java.lang.SuppressWarnings("all")
    private String ref;

    public ManagerBuilder()
    {}

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public Manager.ManagerBuilder value(final String value)
    {
      this.value = value;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public Manager.ManagerBuilder displayName(final String displayName)
    {
      this.displayName = displayName;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public Manager.ManagerBuilder ref(final String ref)
    {
      this.ref = ref;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public Manager build()
    {
      return new Manager(this.value, this.displayName, this.ref);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString()
    {
      return "Manager.ManagerBuilder(value=" + this.value + ", displayName=" + this.displayName + ", ref=" + this.ref
             + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  public static Manager.ManagerBuilder builder()
  {
    return new Manager.ManagerBuilder();
  }
}
