/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.common.tree;

import de.captaingoldfish.scim.sdk.common.tree.TreeNode;
import java.util.HashSet;
import java.util.Set;

public class GenericTree<T> {
    private Set<TreeNode<T>> allNodes = new HashSet<TreeNode<T>>();
    private Set<TreeNode<T>> roots = new HashSet<TreeNode<T>>();
    private Set<TreeNode<T>> leafs = new HashSet<TreeNode<T>>();

    public TreeNode<T> addNewNode(T value) {
        return new TreeNode<T>(this, value);
    }

    protected void addLeaf(TreeNode<T> treeNode) {
        this.leafs.add(treeNode);
    }

    protected void removeLeaf(TreeNode<T> treeNode) {
        this.leafs.remove(treeNode);
    }

    protected void addRoot(TreeNode<T> treeNode) {
        this.roots.add(treeNode);
    }

    protected void removeRoot(TreeNode<T> treeNode) {
        this.roots.remove(treeNode);
    }

    protected void addNode(TreeNode<T> treeNode) {
        this.allNodes.add(treeNode);
    }

    public void removeNodeFromTree(TreeNode<T> treeNode) {
        this.roots.remove(treeNode);
        this.leafs.remove(treeNode);
        this.allNodes.remove(treeNode);
        treeNode.clearParents();
    }

    public void removeBranchFromTree(TreeNode<T> treeNode) {
        Set<TreeNode<T>> branchNodes = treeNode.getAllBranchNodes();
        branchNodes.add(treeNode);
        for (TreeNode<T> node : branchNodes) {
            node.clearParents();
        }
        for (TreeNode<T> node : branchNodes) {
            this.roots.remove(node);
            this.leafs.remove(node);
            this.allNodes.remove(node);
        }
    }

    public TreeNode<T> addDistinctNode(T value) {
        return this.allNodes.stream().filter(node -> node.getValue().equals(value)).findAny().orElseGet(() -> this.addNewNode(value));
    }

    public boolean hasNodes() {
        return !this.getAllNodes().isEmpty();
    }

    public Set<TreeNode<T>> getAllNodes() {
        return new HashSet<TreeNode<T>>(this.allNodes);
    }

    public Set<TreeNode<T>> getRoots() {
        return new HashSet<TreeNode<T>>(this.roots);
    }

    public Set<TreeNode<T>> getLeafs() {
        return new HashSet<TreeNode<T>>(this.leafs);
    }
}

