/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.common.response;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.common.exceptions.InternalServerException;
import de.captaingoldfish.scim.sdk.common.exceptions.ResponseException;
import de.captaingoldfish.scim.sdk.common.exceptions.ScimException;
import de.captaingoldfish.scim.sdk.common.response.ScimResponse;
import java.util.Collections;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorResponse
extends ScimResponse {
    private static final Logger log = LoggerFactory.getLogger(ErrorResponse.class);
    private ScimException scimException;

    public ErrorResponse(JsonNode responseNode) {
        super(responseNode);
        this.setSchemas(Collections.singletonList("urn:ietf:params:scim:api:messages:2.0:Error"));
        this.scimException = new ResponseException(this.getDetail().orElse(null), this.getStatus(), this.getScimType().orElse(null));
    }

    public ErrorResponse(ScimException scimException) {
        super((JsonNode)null);
        this.scimException = scimException;
        if (500 == this.getHttpStatus()) {
            log.error(scimException.getMessage(), (Throwable)scimException);
            this.setDetail("sorry but an internal error has occurred.");
        } else {
            log.debug(scimException.getMessage(), (Throwable)scimException);
            this.setDetail(scimException.getDetail());
        }
        this.setSchemas(Collections.singletonList("urn:ietf:params:scim:api:messages:2.0:Error"));
        this.setStatus(scimException.getStatus());
        this.setScimType(scimException.getScimType());
    }

    public int getStatus() {
        return this.getIntegerAttribute("status").orElseThrow(() -> new InternalServerException("the http 'status' is a mandatory attribute", null, null));
    }

    public void setStatus(int status) {
        this.setAttribute("status", status);
    }

    public Optional<String> getScimType() {
        return this.getStringAttribute("scimType");
    }

    public void setScimType(String scimType) {
        this.setAttribute("scimType", scimType);
    }

    public Optional<String> getDetail() {
        return this.getStringAttribute("detail");
    }

    public void setDetail(String detail) {
        this.setAttribute("detail", detail);
    }

    @Override
    public int getHttpStatus() {
        return this.scimException.getStatus();
    }

    private boolean useEmptyBody() {
        return this.getHttpStatus() < 400 && StringUtils.isBlank((CharSequence)this.getDetail().orElse(null)) && StringUtils.isBlank((CharSequence)this.getScimType().orElse(null));
    }

    public String toString() {
        if (this.useEmptyBody()) {
            return null;
        }
        return super.toString();
    }

    public String toPrettyString() {
        if (this.useEmptyBody()) {
            return null;
        }
        return super.toPrettyString();
    }

    public ScimException getScimException() {
        return this.scimException;
    }
}

