/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.common.resources.complex;

import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import java.util.Optional;

public class PatchConfig
extends ScimObjectNode {
    public PatchConfig(Boolean supported, Boolean activateSailsPointWorkaround, Boolean activateMsAzureWorkaround) {
        super(null);
        this.setSupported(supported);
        this.setActivateSailsPointWorkaround(activateSailsPointWorkaround);
        this.setMsAzureFilterWorkaroundActive(activateMsAzureWorkaround);
    }

    public boolean isSupported() {
        return this.getBooleanAttribute("supported").orElse(false);
    }

    public void setSupported(Boolean supported) {
        this.setAttribute("supported", Optional.ofNullable(supported).orElse(false));
    }

    public boolean isActivateSailsPointWorkaround() {
        return this.getBooleanAttribute("activateSailsPointWorkaround").orElse(false);
    }

    public void setActivateSailsPointWorkaround(Boolean activateSailsPointWorkaround) {
        this.setAttribute("activateSailsPointWorkaround", activateSailsPointWorkaround);
    }

    public boolean isMsAzureFilterWorkaroundActive() {
        return this.getBooleanAttribute("activateMsAzureFilterWorkaround").orElse(false);
    }

    public void setMsAzureFilterWorkaroundActive(Boolean msAzureWorkaroundActive) {
        this.setAttribute("activateMsAzureFilterWorkaround", msAzureWorkaroundActive);
    }

    public static PatchConfigBuilder builder() {
        return new PatchConfigBuilder();
    }

    public PatchConfig() {
    }

    public static class PatchConfigBuilder {
        private Boolean supported;
        private Boolean activateSailsPointWorkaround;
        private Boolean activateMsAzureWorkaround;

        public PatchConfigBuilder supported(Boolean supported) {
            this.supported = supported;
            return this;
        }

        public PatchConfigBuilder activateSailsPointWorkaround(Boolean activateSailsPointWorkaround) {
            this.activateSailsPointWorkaround = activateSailsPointWorkaround;
            return this;
        }

        public PatchConfigBuilder activateMsAzureWorkaround(Boolean activateMsAzureWorkaround) {
            this.activateMsAzureWorkaround = activateMsAzureWorkaround;
            return this;
        }

        public PatchConfig build() {
            return new PatchConfig(this.supported, this.activateSailsPointWorkaround, this.activateMsAzureWorkaround);
        }

        public String toString() {
            return "PatchConfig.PatchConfigBuilder(supported=" + this.supported + ", activateSailsPointWorkaround=" + this.activateSailsPointWorkaround + ", activateMsAzureWorkaround=" + this.activateMsAzureWorkaround + ")";
        }
    }
}

