/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.common.tree;

import de.captaingoldfish.scim.sdk.common.tree.GenericTree;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class TreeNode<T> {
    private final GenericTree<T> tree;
    private final Set<TreeNode<T>> parents;
    private final T value;
    private final Set<TreeNode<T>> children;

    protected TreeNode(GenericTree<T> tree, T value) {
        this.tree = tree;
        this.parents = new HashSet<TreeNode<T>>();
        this.value = Objects.requireNonNull(value);
        this.children = new HashSet<TreeNode<T>>();
        this.tree.addRoot(this);
        this.tree.addLeaf(this);
        this.tree.addNode(this);
    }

    public boolean isRoot() {
        return this.parents.isEmpty();
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public void addParents(TreeNode<T> ... parents) {
        for (TreeNode<T> parent : parents) {
            this.addParent(parent);
        }
    }

    public void addParent(TreeNode<T> parent) {
        Objects.requireNonNull(parent).children.add(this);
        if (this.parents.isEmpty()) {
            this.tree.removeRoot(this);
        }
        this.parents.add(parent);
        if (parent.children.size() == 1) {
            this.tree.removeLeaf(parent);
        }
    }

    public void removeParents(TreeNode<T> ... parents) {
        for (TreeNode<T> parent : parents) {
            this.removeParent(parent);
        }
    }

    public void removeParent(TreeNode<T> parent) {
        Objects.requireNonNull(parent).children.remove(this);
        this.parents.remove(parent);
        if (this.parents.isEmpty()) {
            this.tree.addRoot(this);
        }
        if (parent.children.isEmpty()) {
            this.tree.addLeaf(parent);
        }
    }

    public void addChildren(TreeNode<T> ... children) {
        for (TreeNode<T> child : children) {
            this.addChild(child);
        }
    }

    public void addChild(TreeNode<T> child) {
        Objects.requireNonNull(child).parents.add(this);
        if (this.children.isEmpty()) {
            this.tree.removeLeaf(this);
        }
        this.children.add(child);
        if (child.parents.size() == 1) {
            this.tree.removeRoot(child);
        }
    }

    public void removeChildren(TreeNode<T> ... children) {
        for (TreeNode<T> child : children) {
            this.removeChild(child);
        }
    }

    public void removeChild(TreeNode<T> child) {
        Objects.requireNonNull(child).parents.remove(this);
        this.children.remove(child);
        if (this.children.isEmpty()) {
            this.tree.addLeaf(this);
        }
        if (child.parents.isEmpty()) {
            this.tree.addRoot(child);
        }
    }

    public Set<TreeNode<T>> getParents() {
        return new HashSet<TreeNode<T>>(this.parents);
    }

    public Set<TreeNode<T>> getChildren() {
        return new HashSet<TreeNode<T>>(this.children);
    }

    public Set<TreeNode<T>> getAllBranchNodes() {
        Set<TreeNode<T>> branchNodes = this.getChildren();
        for (TreeNode<T> child : this.children) {
            branchNodes.addAll(child.getAllBranchNodes());
        }
        return branchNodes;
    }

    public void clearParents() {
        for (TreeNode<T> parent : this.getParents()) {
            parent.children.remove(this);
            if (!parent.children.isEmpty()) continue;
            this.tree.addLeaf(parent);
        }
        this.parents.clear();
        this.tree.addRoot(this);
    }

    public String toString() {
        return "TreeNode(value=" + this.getValue() + ")";
    }

    public T getValue() {
        return this.value;
    }
}

