/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.common.resources.multicomplex;

import de.captaingoldfish.scim.sdk.common.exceptions.InvalidConfigException;
import de.captaingoldfish.scim.sdk.common.resources.multicomplex.MultiComplexNode;
import java.util.Objects;
import java.util.Optional;

public class AuthenticationScheme
extends MultiComplexNode {
    public AuthenticationScheme(String name, String description, String type, String specUri, String documentationUri, Boolean primary, String display, String value, String ref) {
        this.setName(name);
        this.setDescription(description);
        this.setAuthenticationType(type);
        this.setSpecUri(specUri);
        this.setDocumentationUri(documentationUri);
        this.setPrimary(primary);
        this.setDisplay(display);
        this.setValue(value);
        this.setRef(ref);
    }

    public AuthenticationScheme(String type, Boolean primary, String display, String value, String ref) {
        super(type, primary, display, value, ref);
    }

    public String getName() {
        return this.getStringAttribute("name").orElseThrow(() -> new InvalidConfigException("the 'name' attribute is required"));
    }

    public void setName(String name) {
        this.setAttribute("name", Objects.requireNonNull(name));
    }

    public String getDescription() {
        return this.getStringAttribute("description").orElseThrow(() -> new InvalidConfigException("the 'description' attribute is required"));
    }

    public void setDescription(String description) {
        this.setAttribute("description", Objects.requireNonNull(description));
    }

    public String getAuthenticationType() {
        return this.getStringAttribute("type").orElseThrow(() -> new InvalidConfigException("the 'type' attribute is required"));
    }

    public void setAuthenticationType(String type) {
        this.setAttribute("type", Objects.requireNonNull(type));
    }

    public Optional<String> getSpecUri() {
        return this.getStringAttribute("specUri");
    }

    public void setSpecUri(String specUri) {
        this.setAttribute("specUri", specUri);
    }

    public Optional<String> getDocumentationUri() {
        return this.getStringAttribute("documentationUri");
    }

    public void setDocumentationUri(String documentationUri) {
        this.setAttribute("documentationUri", documentationUri);
    }

    public String getWwwAuthenticateHeaderRepresentation(String realm) {
        return this.getName() + " realm=\"" + realm + "\"";
    }

    public static AuthenticationSchemeBuilder builder() {
        return new AuthenticationSchemeBuilder();
    }

    public AuthenticationScheme() {
    }

    public static class AuthenticationSchemeBuilder {
        private String name;
        private String description;
        private String type;
        private String specUri;
        private String documentationUri;
        private Boolean primary;
        private String display;
        private String value;
        private String ref;

        AuthenticationSchemeBuilder() {
        }

        public AuthenticationSchemeBuilder name(String name) {
            this.name = name;
            return this;
        }

        public AuthenticationSchemeBuilder description(String description) {
            this.description = description;
            return this;
        }

        public AuthenticationSchemeBuilder type(String type) {
            this.type = type;
            return this;
        }

        public AuthenticationSchemeBuilder specUri(String specUri) {
            this.specUri = specUri;
            return this;
        }

        public AuthenticationSchemeBuilder documentationUri(String documentationUri) {
            this.documentationUri = documentationUri;
            return this;
        }

        public AuthenticationSchemeBuilder primary(Boolean primary) {
            this.primary = primary;
            return this;
        }

        public AuthenticationSchemeBuilder display(String display) {
            this.display = display;
            return this;
        }

        public AuthenticationSchemeBuilder value(String value) {
            this.value = value;
            return this;
        }

        public AuthenticationSchemeBuilder ref(String ref) {
            this.ref = ref;
            return this;
        }

        public AuthenticationScheme build() {
            return new AuthenticationScheme(this.name, this.description, this.type, this.specUri, this.documentationUri, this.primary, this.display, this.value, this.ref);
        }

        public String toString() {
            return "AuthenticationScheme.AuthenticationSchemeBuilder(name=" + this.name + ", description=" + this.description + ", type=" + this.type + ", specUri=" + this.specUri + ", documentationUri=" + this.documentationUri + ", primary=" + this.primary + ", display=" + this.display + ", value=" + this.value + ", ref=" + this.ref + ")";
        }
    }
}

