// Generated by delombok at Wed May 18 07:42:35 CEST 2022
package de.captaingoldfish.scim.sdk.common.resources.multicomplex;

import java.util.Optional;
import de.captaingoldfish.scim.sdk.common.constants.AttributeNames;


/**
 * author Pascal Knueppel <br>
 * created at: 11.10.2019 - 12:36 <br>
 * <br>
 * A physical mailing address for this user. Canonical type values of "work", "home", and "other". This
 * attribute is a complex type with the following sub-attributes. All sub-attributes are OPTIONAL.
 */
public class Address extends MultiComplexNode
{

  public Address(String type,
                 Boolean primary,
                 String display,
                 String value,
                 String ref,
                 String formatted,
                 String streetAddress,
                 String locality,
                 String region,
                 String postalCode,
                 String country)
  {
    super(type, primary, display, value, ref);
    setFormatted(formatted);
    setStreetAddress(streetAddress);
    setLocality(locality);
    setRegion(region);
    setPostalCode(postalCode);
    setCountry(country);
  }

  /**
   * The full mailing address, formatted for display or use with a mailing label. This attribute MAY contain
   * newlines.
   */
  public Optional<String> getFormatted()
  {
    return getStringAttribute(AttributeNames.RFC7643.FORMATTED);
  }

  /**
   * The full mailing address, formatted for display or use with a mailing label. This attribute MAY contain
   * newlines.
   */
  public void setFormatted(String formatted)
  {
    setAttribute(AttributeNames.RFC7643.FORMATTED, formatted);
  }

  /**
   * The full street address component, which may include house number, street name, P.O. box, and multi-line
   * extended street address information. This attribute MAY contain newlines.
   */
  public Optional<String> getStreetAddress()
  {
    return getStringAttribute(AttributeNames.RFC7643.STREET_ADDRESS);
  }

  /**
   * The full street address component, which may include house number, street name, P.O. box, and multi-line
   * extended street address information. This attribute MAY contain newlines.
   */
  public void setStreetAddress(String streetAddress)
  {
    setAttribute(AttributeNames.RFC7643.STREET_ADDRESS, streetAddress);
  }

  /**
   * The city or locality component.
   */
  public Optional<String> getLocality()
  {
    return getStringAttribute(AttributeNames.RFC7643.LOCALITY);
  }

  /**
   * The city or locality component.
   */
  public void setLocality(String locality)
  {
    setAttribute(AttributeNames.RFC7643.LOCALITY, locality);
  }

  /**
   * The state or region component.
   */
  public Optional<String> getRegion()
  {
    return getStringAttribute(AttributeNames.RFC7643.REGION);
  }

  /**
   * The state or region component.
   */
  public void setRegion(String region)
  {
    setAttribute(AttributeNames.RFC7643.REGION, region);
  }

  /**
   * The zip code or postal code component.
   */
  public Optional<String> getPostalCode()
  {
    return getStringAttribute(AttributeNames.RFC7643.POSTAL_CODE);
  }

  /**
   * The zip code or postal code component.
   */
  public void setPostalCode(String postalCode)
  {
    setAttribute(AttributeNames.RFC7643.POSTAL_CODE, postalCode);
  }

  /**
   * The country name component. When specified, the value MUST be in ISO 3166-1 "alpha-2" code format
   * [ISO3166]; e.g., the United States and Sweden are "US" and "SE", respectively.
   */
  public Optional<String> getCountry()
  {
    return getStringAttribute(AttributeNames.RFC7643.COUNTRY);
  }

  /**
   * The country name component. When specified, the value MUST be in ISO 3166-1 "alpha-2" code format
   * [ISO3166]; e.g., the United States and Sweden are "US" and "SE", respectively.
   */
  public void setCountry(String country)
  {
    setAttribute(AttributeNames.RFC7643.COUNTRY, country);
  }


  @java.lang.SuppressWarnings("all")
  public static class AddressBuilder
  {

    @java.lang.SuppressWarnings("all")
    private String type;

    @java.lang.SuppressWarnings("all")
    private Boolean primary;

    @java.lang.SuppressWarnings("all")
    private String display;

    @java.lang.SuppressWarnings("all")
    private String value;

    @java.lang.SuppressWarnings("all")
    private String ref;

    @java.lang.SuppressWarnings("all")
    private String formatted;

    @java.lang.SuppressWarnings("all")
    private String streetAddress;

    @java.lang.SuppressWarnings("all")
    private String locality;

    @java.lang.SuppressWarnings("all")
    private String region;

    @java.lang.SuppressWarnings("all")
    private String postalCode;

    @java.lang.SuppressWarnings("all")
    private String country;

    @java.lang.SuppressWarnings("all")
    AddressBuilder()
    {}

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public Address.AddressBuilder type(final String type)
    {
      this.type = type;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public Address.AddressBuilder primary(final Boolean primary)
    {
      this.primary = primary;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public Address.AddressBuilder display(final String display)
    {
      this.display = display;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public Address.AddressBuilder value(final String value)
    {
      this.value = value;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public Address.AddressBuilder ref(final String ref)
    {
      this.ref = ref;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public Address.AddressBuilder formatted(final String formatted)
    {
      this.formatted = formatted;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public Address.AddressBuilder streetAddress(final String streetAddress)
    {
      this.streetAddress = streetAddress;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public Address.AddressBuilder locality(final String locality)
    {
      this.locality = locality;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public Address.AddressBuilder region(final String region)
    {
      this.region = region;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public Address.AddressBuilder postalCode(final String postalCode)
    {
      this.postalCode = postalCode;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public Address.AddressBuilder country(final String country)
    {
      this.country = country;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public Address build()
    {
      return new Address(this.type, this.primary, this.display, this.value, this.ref, this.formatted,
                         this.streetAddress, this.locality, this.region, this.postalCode, this.country);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString()
    {
      return "Address.AddressBuilder(type=" + this.type + ", primary=" + this.primary + ", display=" + this.display
             + ", value=" + this.value + ", ref=" + this.ref + ", formatted=" + this.formatted + ", streetAddress="
             + this.streetAddress + ", locality=" + this.locality + ", region=" + this.region + ", postalCode="
             + this.postalCode + ", country=" + this.country + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  public static Address.AddressBuilder builder()
  {
    return new Address.AddressBuilder();
  }

  @java.lang.SuppressWarnings("all")
  public Address()
  {}
}
