/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.common.resources.complex;

import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import java.util.Optional;

public class BulkConfig
extends ScimObjectNode {
    protected static final Integer DEFAULT_MAX_OPERATIONS = 1;
    protected static final Long DEFAULT_MAX_PAYLOAD_SIZE = (long)(Math.pow(1024.0, 2.0) * 2.0);

    public BulkConfig(Boolean supported, Integer maxOperations, Long maxPayloadSize, Boolean returnResourcesEnabled, Boolean returnResourcesByDefault) {
        super(null);
        this.setSupported(supported);
        this.setMaxOperations(maxOperations);
        this.setMaxPayloadSize(maxPayloadSize);
        this.setReturnResourcesEnabled(returnResourcesEnabled);
        this.setReturnResourcesByDefault(returnResourcesByDefault);
    }

    public boolean isSupported() {
        return this.getBooleanAttribute("supported").orElse(false);
    }

    public void setSupported(Boolean supported) {
        this.setAttribute("supported", Optional.ofNullable(supported).orElse(false));
    }

    public Integer getMaxOperations() {
        return this.getLongAttribute("maxOperations").orElse((long)DEFAULT_MAX_OPERATIONS).intValue();
    }

    public void setMaxOperations(Integer maxOperations) {
        Long max = maxOperations == null ? null : Long.valueOf(maxOperations.intValue());
        this.setAttribute("maxOperations", Optional.ofNullable(max).orElse((long)DEFAULT_MAX_OPERATIONS));
    }

    public Long getMaxPayloadSize() {
        return this.getLongAttribute("maxPayloadSize").orElse(DEFAULT_MAX_PAYLOAD_SIZE);
    }

    public void setMaxPayloadSize(Long maxPayloadSize) {
        this.setAttribute("maxPayloadSize", Optional.ofNullable(maxPayloadSize).orElse(DEFAULT_MAX_PAYLOAD_SIZE));
    }

    public boolean isReturnResourcesEnabled() {
        return this.getBooleanAttribute("returnResourcesEnabled").orElse(false);
    }

    public void setReturnResourcesEnabled(Boolean returnResourcesEnabled) {
        this.setAttribute("returnResourcesEnabled", Optional.ofNullable(returnResourcesEnabled).orElse(false));
    }

    public boolean isReturnResourcesByDefault() {
        return this.isReturnResourcesEnabled() && this.getBooleanAttribute("returnResourcesByDefault").orElse(false) != false;
    }

    public void setReturnResourcesByDefault(Boolean returnResourcesByDefault) {
        boolean effectiveValue = Optional.ofNullable(returnResourcesByDefault).orElse(false);
        if (effectiveValue) {
            this.setReturnResourcesEnabled(true);
        }
        this.setAttribute("returnResourcesByDefault", effectiveValue);
    }

    public static BulkConfigBuilder builder() {
        return new BulkConfigBuilder();
    }

    public BulkConfig() {
    }

    public static class BulkConfigBuilder {
        private Boolean supported;
        private Integer maxOperations;
        private Long maxPayloadSize;
        private Boolean returnResourcesEnabled;
        private Boolean returnResourcesByDefault;

        BulkConfigBuilder() {
        }

        public BulkConfigBuilder supported(Boolean supported) {
            this.supported = supported;
            return this;
        }

        public BulkConfigBuilder maxOperations(Integer maxOperations) {
            this.maxOperations = maxOperations;
            return this;
        }

        public BulkConfigBuilder maxPayloadSize(Long maxPayloadSize) {
            this.maxPayloadSize = maxPayloadSize;
            return this;
        }

        public BulkConfigBuilder returnResourcesEnabled(Boolean returnResourcesEnabled) {
            this.returnResourcesEnabled = returnResourcesEnabled;
            return this;
        }

        public BulkConfigBuilder returnResourcesByDefault(Boolean returnResourcesByDefault) {
            this.returnResourcesByDefault = returnResourcesByDefault;
            return this;
        }

        public BulkConfig build() {
            return new BulkConfig(this.supported, this.maxOperations, this.maxPayloadSize, this.returnResourcesEnabled, this.returnResourcesByDefault);
        }

        public String toString() {
            return "BulkConfig.BulkConfigBuilder(supported=" + this.supported + ", maxOperations=" + this.maxOperations + ", maxPayloadSize=" + this.maxPayloadSize + ", returnResourcesEnabled=" + this.returnResourcesEnabled + ", returnResourcesByDefault=" + this.returnResourcesByDefault + ")";
        }
    }
}

