// Generated by delombok at Fri Apr 01 13:57:56 CEST 2022
package de.captaingoldfish.scim.sdk.common.resources.complex;

import java.util.Optional;
import de.captaingoldfish.scim.sdk.common.constants.AttributeNames;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;


/**
 * author Pascal Knueppel <br>
 * created at: 18.10.2019 - 11:12 <br>
 * <br>
 * A complex type that specifies PATCH configuration options. REQUIRED. See Section 3.5.2 of [RFC7644].
 */
public class PatchConfig extends ScimObjectNode
{

  public PatchConfig(Boolean supported)
  {
    super(null);
    setSupported(supported);
  }

  /**
   * A Boolean value specifying whether or not the operation is supported. REQUIRED.
   */
  public boolean isSupported()
  {
    return getBooleanAttribute(AttributeNames.RFC7643.SUPPORTED).orElse(false);
  }

  /**
   * A Boolean value specifying whether or not the operation is supported. REQUIRED.
   */
  public void setSupported(Boolean supported)
  {
    setAttribute(AttributeNames.RFC7643.SUPPORTED, Optional.ofNullable(supported).orElse(false));
  }


  @java.lang.SuppressWarnings("all")
  public static class PatchConfigBuilder
  {

    @java.lang.SuppressWarnings("all")
    private Boolean supported;

    @java.lang.SuppressWarnings("all")
    PatchConfigBuilder()
    {}

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public PatchConfig.PatchConfigBuilder supported(final Boolean supported)
    {
      this.supported = supported;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public PatchConfig build()
    {
      return new PatchConfig(this.supported);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString()
    {
      return "PatchConfig.PatchConfigBuilder(supported=" + this.supported + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  public static PatchConfig.PatchConfigBuilder builder()
  {
    return new PatchConfig.PatchConfigBuilder();
  }

  @java.lang.SuppressWarnings("all")
  public PatchConfig()
  {}
}
