/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.common.response;

import de.captaingoldfish.scim.sdk.common.constants.enums.HttpMethod;
import de.captaingoldfish.scim.sdk.common.exceptions.BadRequestException;
import de.captaingoldfish.scim.sdk.common.exceptions.InternalServerException;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import de.captaingoldfish.scim.sdk.common.response.ErrorResponse;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class BulkResponseOperation
extends ScimObjectNode {
    protected static final List<HttpMethod> VALID_METHODS = Arrays.asList(HttpMethod.POST, HttpMethod.PUT, HttpMethod.PATCH, HttpMethod.DELETE);

    public BulkResponseOperation() {
        super(null);
    }

    public BulkResponseOperation(HttpMethod method, String bulkId, String version, String location, Integer status, ErrorResponse response) {
        this();
        this.setMethod(method);
        this.setBulkId(bulkId);
        this.setVersion(version);
        this.setLocation(location);
        this.setStatus(status);
        this.setResponse(response);
    }

    public HttpMethod getMethod() {
        return this.getStringAttribute("method").map(HttpMethod::valueOf).orElseThrow(() -> new InternalServerException("the 'method' attribute is mandatory", null, null));
    }

    public void setMethod(HttpMethod method) {
        if (method != null && !VALID_METHODS.contains((Object)method)) {
            throw new BadRequestException("bulk does only support the following methods '" + VALID_METHODS + "' but found method: " + (Object)((Object)method), null, "invalidParameters");
        }
        this.setAttribute("method", method == null ? null : method.name());
    }

    public Optional<String> getBulkId() {
        return this.getStringAttribute("bulkId");
    }

    public void setBulkId(String bulkId) {
        this.setAttribute("bulkId", bulkId);
    }

    public Optional<String> getVersion() {
        return this.getStringAttribute("version");
    }

    public void setVersion(String version) {
        this.setAttribute("version", version);
    }

    public Optional<String> getLocation() {
        return this.getStringAttribute("location");
    }

    public void setLocation(String location) {
        this.setAttribute("location", location);
    }

    public Integer getStatus() {
        return this.getLongAttribute("status").map(Long::intValue).orElseThrow(() -> new InternalServerException("attribute 'status' is mandatory", null, null));
    }

    public void setStatus(Integer status) {
        this.setAttribute("status", status == null ? null : Long.valueOf(status.longValue()));
    }

    public Optional<ErrorResponse> getResponse() {
        return Optional.ofNullable(this.get("response")).map(ErrorResponse::new);
    }

    public void setResponse(ErrorResponse response) {
        this.setAttribute("response", response);
    }

    public static BulkResponseOperationBuilder builder() {
        return new BulkResponseOperationBuilder();
    }

    public static class BulkResponseOperationBuilder {
        private HttpMethod method;
        private String bulkId;
        private String version;
        private String location;
        private Integer status;
        private ErrorResponse response;

        BulkResponseOperationBuilder() {
        }

        public BulkResponseOperationBuilder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        public BulkResponseOperationBuilder bulkId(String bulkId) {
            this.bulkId = bulkId;
            return this;
        }

        public BulkResponseOperationBuilder version(String version) {
            this.version = version;
            return this;
        }

        public BulkResponseOperationBuilder location(String location) {
            this.location = location;
            return this;
        }

        public BulkResponseOperationBuilder status(Integer status) {
            this.status = status;
            return this;
        }

        public BulkResponseOperationBuilder response(ErrorResponse response) {
            this.response = response;
            return this;
        }

        public BulkResponseOperation build() {
            return new BulkResponseOperation(this.method, this.bulkId, this.version, this.location, this.status, this.response);
        }

        public String toString() {
            return "BulkResponseOperation.BulkResponseOperationBuilder(method=" + (Object)((Object)this.method) + ", bulkId=" + this.bulkId + ", version=" + this.version + ", location=" + this.location + ", status=" + this.status + ", response=" + this.response + ")";
        }
    }
}

