/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.client.response;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import de.captaingoldfish.scim.sdk.client.http.HttpResponse;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import de.captaingoldfish.scim.sdk.common.response.ErrorResponse;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerResponse<T extends ScimObjectNode> {
    private static final Logger log = LoggerFactory.getLogger(ServerResponse.class);
    private final HttpResponse httpResponse;
    private final boolean success;
    private T resource;
    private ErrorResponse errorResponse;
    private Boolean validScimResponse;
    private Class<T> type;
    private Function<HttpResponse, Boolean> isResponseParseable;

    public ServerResponse(HttpResponse httpResponse, boolean expectedResponseCode, Class<T> type, Function<HttpResponse, Boolean> isResponseParseable) {
        this.httpResponse = httpResponse;
        this.success = expectedResponseCode && this.isValidScimResponse();
        this.type = type;
        this.isResponseParseable = isResponseParseable;
    }

    public T getResource() {
        boolean isParseable;
        boolean isSuccessResponse = this.resource == null && this.success && StringUtils.isNotBlank((CharSequence)this.getResponseBody()) && this.isValidScimResponse();
        Boolean result = this.isResponseParseable.apply(this.httpResponse);
        boolean bl = isParseable = result != null && result != false;
        if (isParseable || isSuccessResponse) {
            this.resource = this.getResource(this.type);
        }
        return this.resource;
    }

    public <R extends ScimObjectNode> R getResource(Class<R> responseType) {
        return (R)((ScimObjectNode)JsonHelper.readJsonDocument((String)this.getResponseBody(), responseType));
    }

    public boolean isValidScimResponse() {
        if (this.validScimResponse == null) {
            this.validScimResponse = this.doesHeaderMapContain("Content-Type", "application/scim+json") && (this.getResponseBody() != null && JsonHelper.isValidJson((String)this.getResponseBody()) || this.getResponseBody() == null);
        }
        return this.validScimResponse;
    }

    public ErrorResponse getErrorResponse() {
        if (this.errorResponse == null && !this.success && StringUtils.isNotBlank((CharSequence)this.getResponseBody()) && this.isValidScimResponse() && this.isUriInSchemasElement("urn:ietf:params:scim:api:messages:2.0:Error")) {
            this.errorResponse = (ErrorResponse)JsonHelper.readJsonDocument((String)this.getResponseBody(), ErrorResponse.class);
        }
        return this.errorResponse;
    }

    public Map<String, String> getHttpHeaders() {
        return this.httpResponse.getResponseHeaders();
    }

    public String getResponseBody() {
        return this.httpResponse.getResponseBody();
    }

    public int getHttpStatus() {
        return this.httpResponse.getHttpStatusCode();
    }

    private boolean doesHeaderMapContain(String headerName, String expectedValue) {
        List headerNameList = this.getHttpHeaders().keySet().stream().filter(name -> name.equalsIgnoreCase(headerName)).collect(Collectors.toList());
        if (headerNameList.size() > 1) {
            log.error("could not validate header value for duplicate headerName found in response: {} -> {}", (Object)headerName, (Object)String.join((CharSequence)", ", headerNameList));
        }
        return headerNameList.size() == 1 && StringUtils.startsWithIgnoreCase((CharSequence)this.getHttpHeaders().get(headerNameList.get(0)), (CharSequence)expectedValue);
    }

    private boolean isUriInSchemasElement(String uri) {
        if (!this.isValidScimResponse() || StringUtils.isBlank((CharSequence)this.getResponseBody())) {
            return false;
        }
        ScimObjectNode scimObjectNode = (ScimObjectNode)JsonHelper.readJsonDocument((String)this.getResponseBody(), ScimObjectNode.class);
        ArrayNode schemasNode = (ArrayNode)scimObjectNode.get("schemas");
        if (schemasNode == null || schemasNode.isEmpty()) {
            return false;
        }
        for (JsonNode jsonNode : schemasNode) {
            if (!uri.equals(jsonNode.textValue())) continue;
            return true;
        }
        return false;
    }

    public boolean isSuccess() {
        return this.success;
    }

    protected Class<T> getType() {
        return this.type;
    }
}

