/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.client.keys;

import de.captaingoldfish.scim.sdk.client.keys.SecurityProvider;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyReader {
    private static final Logger log = LoggerFactory.getLogger(KeyReader.class);

    public static PrivateKey readPrivateRSAKey(byte[] privateKey) {
        log.trace("trying to create private key. privateKey.length: {}-bytes", (Object)privateKey.length);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA", SecurityProvider.BOUNCY_CASTLE_PROVIDER);
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(privateKey);
        return keyFactory.generatePrivate(privateKeySpec);
    }

    public static X509Certificate readX509Certificate(byte[] certificateBytes) {
        return KeyReader.readX509Certificate(new ByteArrayInputStream(certificateBytes));
    }

    public static X509Certificate readX509Certificate(InputStream certificateStream) {
        X509Certificate x509Certificate;
        block8: {
            InputStream in = certificateStream;
            try {
                CertificateFactory certFactory = CertificateFactory.getInstance("X.509", SecurityProvider.BOUNCY_CASTLE_PROVIDER);
                X509Certificate x509Certificate2 = (X509Certificate)certFactory.generateCertificate(in);
                log.trace("X509 certificate was successfully read.");
                x509Certificate = x509Certificate2;
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            in.close();
        }
        return x509Certificate;
    }

    private KeyReader() {
    }
}

