/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.client.builder;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.client.builder.ETagRequestBuilder;
import de.captaingoldfish.scim.sdk.client.builder.RequestBuilder;
import de.captaingoldfish.scim.sdk.client.http.ScimHttpClient;
import de.captaingoldfish.scim.sdk.common.constants.enums.PatchOp;
import de.captaingoldfish.scim.sdk.common.request.PatchOpRequest;
import de.captaingoldfish.scim.sdk.common.request.PatchRequestOperation;
import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

public class PatchBuilder<T extends ResourceNode>
extends ETagRequestBuilder<T> {
    private final String fullUrl;
    private List<PatchRequestOperation> operations = new ArrayList<PatchRequestOperation>();

    public PatchBuilder(String fullUrl, Class<T> responseEntityType, ScimHttpClient scimHttpClient) {
        super(responseEntityType, scimHttpClient);
        this.fullUrl = fullUrl;
    }

    public PatchBuilder(String baseUrl, String endpoint, String resourceId, Class<T> responseEntityType, ScimHttpClient scimHttpClient) {
        super(baseUrl, endpoint + (StringUtils.isBlank((CharSequence)resourceId) ? "" : "/" + resourceId), responseEntityType, scimHttpClient);
        this.fullUrl = null;
    }

    @Override
    protected boolean isExpectedResponseCode(int httpStatus) {
        return 200 == httpStatus;
    }

    public RequestBuilder<T> setPatchResource(PatchOpRequest resource) {
        return super.setResource((JsonNode)resource);
    }

    public RequestBuilder<T> setPatchResource(String resource) {
        return super.setResource(resource);
    }

    public PatchOperationBuilder<T> addOperation() {
        return new PatchOperationBuilder(this);
    }

    @Override
    protected HttpUriRequest getHttpUriRequest() {
        HttpPatch httpPatch = StringUtils.isBlank((CharSequence)this.fullUrl) ? new HttpPatch(this.getBaseUrl() + this.getEndpoint()) : new HttpPatch(this.fullUrl);
        StringEntity stringEntity = new StringEntity(this.getResource(), StandardCharsets.UTF_8);
        httpPatch.setEntity((HttpEntity)stringEntity);
        return httpPatch;
    }

    @Override
    public final String getResource() {
        return new PatchOpRequest(this.operations).toString();
    }

    public static class PatchOperationBuilder<T extends ResourceNode> {
        private PatchBuilder<T> patchBuilder;
        private PatchRequestOperation.PatchRequestOperationBuilder builder;

        public PatchOperationBuilder(PatchBuilder<T> patchBuilder) {
            this.patchBuilder = patchBuilder;
            this.builder = PatchRequestOperation.builder();
        }

        public PatchOperationBuilder<T> path(String path) {
            this.builder.path(path);
            return this;
        }

        public PatchOperationBuilder<T> op(PatchOp op) {
            this.builder.op(op);
            return this;
        }

        public PatchOperationBuilder<T> value(String values) {
            this.builder.values(Collections.singletonList(values));
            return this;
        }

        public PatchOperationBuilder<T> values(List<String> values) {
            this.builder.values(values);
            return this;
        }

        public PatchOperationBuilder<T> valueNode(JsonNode valueNode) {
            this.builder.valueNode(valueNode);
            return this;
        }

        public PatchBuilder<T> build() {
            ((PatchBuilder)this.patchBuilder).operations.add(this.builder.build());
            return this.patchBuilder;
        }

        public PatchOperationBuilder<T> next() {
            this.build();
            return new PatchOperationBuilder<T>(this.patchBuilder);
        }
    }
}

