/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.client.builder;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.client.builder.RequestBuilder;
import de.captaingoldfish.scim.sdk.client.http.HttpResponse;
import de.captaingoldfish.scim.sdk.client.http.ScimHttpClient;
import de.captaingoldfish.scim.sdk.client.response.ServerResponse;
import de.captaingoldfish.scim.sdk.common.constants.enums.HttpMethod;
import de.captaingoldfish.scim.sdk.common.etag.ETag;
import de.captaingoldfish.scim.sdk.common.request.BulkRequest;
import de.captaingoldfish.scim.sdk.common.request.BulkRequestOperation;
import de.captaingoldfish.scim.sdk.common.response.BulkResponse;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

public class BulkBuilder
extends RequestBuilder<BulkResponse> {
    private final BulkRequest.BulkRequestBuilder builder = BulkRequest.builder();
    private final List<BulkRequestOperation> bulkRequestOperationList = new ArrayList<BulkRequestOperation>();
    private final String fullUrl;

    public BulkBuilder(String baseUrl, ScimHttpClient scimHttpClient, boolean isFullUrl) {
        super(isFullUrl ? null : baseUrl, "/Bulk", BulkResponse.class, scimHttpClient);
        this.builder.bulkRequestOperation(this.bulkRequestOperationList);
        this.fullUrl = isFullUrl ? baseUrl : null;
    }

    @Override
    protected boolean isExpectedResponseCode(int httpStatus) {
        return 200 == httpStatus;
    }

    @Override
    protected HttpUriRequest getHttpUriRequest() {
        HttpPost httpPost = StringUtils.isBlank((CharSequence)this.fullUrl) ? new HttpPost(this.getBaseUrl() + this.getEndpoint()) : new HttpPost(this.fullUrl);
        StringEntity stringEntity = new StringEntity(this.getResource(), StandardCharsets.UTF_8);
        httpPost.setEntity((HttpEntity)stringEntity);
        return httpPost;
    }

    @Override
    protected String getResource() {
        return this.builder.build().toString();
    }

    @Override
    protected Function<HttpResponse, Boolean> isResponseParseable() {
        return httpResponse -> {
            String responseBody = httpResponse.getResponseBody();
            if (StringUtils.isNotBlank((CharSequence)responseBody) && responseBody.contains("urn:ietf:params:scim:api:messages:2.0:BulkResponse")) {
                return true;
            }
            return false;
        };
    }

    public BulkBuilder failOnErrors(Integer failOnErrors) {
        this.builder.failOnErrors(failOnErrors);
        return this;
    }

    public BulkRequestOperationCreator bulkRequestOperation(String path) {
        return this.bulkRequestOperation(path, null);
    }

    public BulkRequestOperationCreator bulkRequestOperation(String path, String id) {
        String idPath = StringUtils.isBlank((CharSequence)id) ? "" : "/" + id;
        return new BulkRequestOperationCreator(this, path + idPath);
    }

    protected List<BulkRequestOperation> getBulkRequestOperationList() {
        return this.bulkRequestOperationList;
    }

    public static class BulkRequestOperationCreator {
        private final BulkBuilder bulkBuilder;
        private final BulkRequestOperation.BulkRequestOperationBuilder builder = BulkRequestOperation.builder();

        public BulkRequestOperationCreator(BulkBuilder bulkBuilder, String path) {
            this.bulkBuilder = bulkBuilder;
            this.builder.path(path);
        }

        public BulkRequestOperationCreator method(HttpMethod method) {
            this.builder.method(method);
            return this;
        }

        public BulkRequestOperationCreator bulkId(String bulkId) {
            this.builder.bulkId(bulkId);
            return this;
        }

        public BulkRequestOperationCreator data(String data) {
            this.builder.data(data);
            return this;
        }

        public BulkRequestOperationCreator data(JsonNode data) {
            this.builder.data(data.toString());
            return this;
        }

        public BulkRequestOperationCreator version(ETag version) {
            this.builder.version(version);
            return this;
        }

        public BulkBuilder next() {
            this.bulkBuilder.getBulkRequestOperationList().add(this.builder.build());
            return this.bulkBuilder;
        }

        public ServerResponse<BulkResponse> sendRequest() {
            return this.sendRequest(Collections.emptyMap());
        }

        public ServerResponse<BulkResponse> sendRequest(Map<String, String> httpHeaders) {
            return this.next().sendRequest(httpHeaders);
        }

        public ServerResponse<BulkResponse> sendRequestWithMultiHeaders(Map<String, String[]> httpHeaders) {
            return this.next().sendRequestWithMultiHeaders(httpHeaders);
        }
    }
}

