/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.client.builder;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.client.builder.ETagRequestBuilder;
import de.captaingoldfish.scim.sdk.client.builder.ScimClientConfig;
import de.captaingoldfish.scim.sdk.common.etag.ETag;
import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;
import de.captaingoldfish.scim.sdk.common.response.ErrorResponse;
import de.captaingoldfish.scim.sdk.common.response.ScimResponse;
import de.captaingoldfish.scim.sdk.common.response.UpdateResponse;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

public class UpdateBuilder<T extends ResourceNode>
extends ETagRequestBuilder<T> {
    private String id;

    public UpdateBuilder(String baseUrl, ScimClientConfig scimClientConfig, Class<T> responseEntityType) {
        super(baseUrl, scimClientConfig, responseEntityType);
    }

    public UpdateBuilder<T> setId(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalStateException("id must not be blank for update-requests");
        }
        this.id = id;
        return this;
    }

    @Override
    public UpdateBuilder<T> setResource(String resource) {
        return (UpdateBuilder)super.setResource(resource);
    }

    @Override
    public UpdateBuilder<T> setResource(JsonNode resource) {
        return (UpdateBuilder)super.setResource(resource);
    }

    @Override
    public UpdateBuilder<T> setEndpoint(String endpoint) {
        return (UpdateBuilder)super.setEndpoint(endpoint);
    }

    @Override
    public UpdateBuilder<T> setETagForIfMatch(String version) {
        return (UpdateBuilder)super.setETagForIfMatch(version);
    }

    @Override
    public UpdateBuilder<T> setETagForIfNoneMatch(String version) {
        return (UpdateBuilder)super.setETagForIfNoneMatch(version);
    }

    @Override
    public UpdateBuilder<T> setETagForIfMatch(ETag version) {
        return (UpdateBuilder)super.setETagForIfMatch(version);
    }

    @Override
    public UpdateBuilder<T> setETagForIfNoneMatch(ETag version) {
        return (UpdateBuilder)super.setETagForIfNoneMatch(version);
    }

    @Override
    protected <T1 extends ScimResponse> Class<T1> getResponseType(int responseCode) {
        return 200 == responseCode ? UpdateResponse.class : ErrorResponse.class;
    }

    @Override
    protected HttpUriRequest getHttpUriRequest() {
        if (StringUtils.isBlank((CharSequence)this.id)) {
            throw new IllegalStateException("id must not be blank for get-requests");
        }
        HttpPut httpPut = new HttpPut(this.getBaseUrl() + this.getEndpoint() + "/" + this.id);
        if (StringUtils.isBlank((CharSequence)this.getResource())) {
            throw new IllegalArgumentException("resource for delete request must not be empty");
        }
        StringEntity stringEntity = new StringEntity(this.getResource(), StandardCharsets.UTF_8);
        httpPut.setEntity((HttpEntity)stringEntity);
        if (this.isUseIfMatch()) {
            httpPut.setHeader("If-Match", this.getVersion().toString());
        }
        if (this.isUseIfNoneMatch()) {
            httpPut.setHeader("If-None-Match", this.getVersion().toString());
        }
        return httpPut;
    }
}

