/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.client.builder;

import de.captaingoldfish.scim.sdk.client.builder.RequestBuilder;
import de.captaingoldfish.scim.sdk.client.builder.ScimClientConfig;
import de.captaingoldfish.scim.sdk.common.etag.ETag;
import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;

public abstract class ETagRequestBuilder<T extends ResourceNode>
extends RequestBuilder<T> {
    private ETag version;
    private boolean useIfMatch;
    private boolean useIfNoneMatch;

    public ETagRequestBuilder(String baseUrl, ScimClientConfig scimClientConfig, Class<T> responseEntityType) {
        super(baseUrl, scimClientConfig, responseEntityType);
    }

    public ETagRequestBuilder<T> setETagForIfMatch(String version) {
        this.version = ETag.newInstance((String)version);
        if (this.useIfNoneMatch) {
            throw new IllegalStateException("cannot use both headers 'If-Match' and 'If-None-Match' in a single request");
        }
        this.useIfMatch = true;
        return this;
    }

    public ETagRequestBuilder<T> setETagForIfNoneMatch(String version) {
        this.version = ETag.newInstance((String)version);
        if (this.useIfMatch) {
            throw new IllegalStateException("cannot use both headers 'If-Match' and 'If-None-Match' in a single request");
        }
        this.useIfNoneMatch = true;
        return this;
    }

    public ETagRequestBuilder<T> setETagForIfMatch(ETag version) {
        this.version = version;
        if (this.useIfNoneMatch) {
            throw new IllegalStateException("cannot use both headers 'If-Match' and 'If-None-Match' in a single request");
        }
        this.useIfMatch = true;
        return this;
    }

    public ETagRequestBuilder<T> setETagForIfNoneMatch(ETag version) {
        this.version = version;
        if (this.useIfMatch) {
            throw new IllegalStateException("cannot use both headers 'If-Match' and 'If-None-Match' in a single request");
        }
        this.useIfNoneMatch = true;
        return this;
    }

    protected ETag getVersion() {
        return this.version;
    }

    protected boolean isUseIfMatch() {
        return this.useIfMatch;
    }

    protected boolean isUseIfNoneMatch() {
        return this.useIfNoneMatch;
    }
}

