/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.client.builder;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.client.builder.RequestBuilder;
import de.captaingoldfish.scim.sdk.client.builder.ScimClientConfig;
import de.captaingoldfish.scim.sdk.client.exceptions.InvalidRequestException;
import de.captaingoldfish.scim.sdk.client.response.ScimServerResponse;
import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;
import de.captaingoldfish.scim.sdk.common.response.CreateResponse;
import de.captaingoldfish.scim.sdk.common.response.ErrorResponse;
import de.captaingoldfish.scim.sdk.common.response.ScimResponse;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

public class CreateBuilder<T extends ResourceNode>
extends RequestBuilder<T> {
    public CreateBuilder(String baseUrl, ScimClientConfig scimClientConfig, Class<T> responseEntityType) {
        super(baseUrl, scimClientConfig, responseEntityType);
    }

    @Override
    public CreateBuilder<T> setEndpoint(String endpoint) {
        return (CreateBuilder)super.setEndpoint(endpoint);
    }

    @Override
    public CreateBuilder<T> setResource(String resource) {
        return (CreateBuilder)super.setResource(resource);
    }

    @Override
    public CreateBuilder<T> setResource(JsonNode resource) {
        return (CreateBuilder)super.setResource(resource);
    }

    @Override
    public ScimServerResponse<T> sendRequest() {
        if (StringUtils.isBlank((CharSequence)this.getResource())) {
            throw new InvalidRequestException("no resource set");
        }
        return super.sendRequest();
    }

    @Override
    protected HttpUriRequest getHttpUriRequest() {
        HttpPost httpPost = new HttpPost(this.getBaseUrl() + this.getEndpoint());
        StringEntity stringEntity = new StringEntity(this.getResource(), StandardCharsets.UTF_8);
        httpPost.setEntity((HttpEntity)stringEntity);
        return httpPost;
    }

    @Override
    protected <T extends ScimResponse> Class<T> getResponseType(int responseCode) {
        return responseCode == 201 ? CreateResponse.class : ErrorResponse.class;
    }
}

