/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.client.response;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.client.constants.ResponseType;
import de.captaingoldfish.scim.sdk.common.exceptions.ResponseException;
import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;
import de.captaingoldfish.scim.sdk.common.response.BulkResponse;
import de.captaingoldfish.scim.sdk.common.response.CreateResponse;
import de.captaingoldfish.scim.sdk.common.response.DeleteResponse;
import de.captaingoldfish.scim.sdk.common.response.ErrorResponse;
import de.captaingoldfish.scim.sdk.common.response.GetResponse;
import de.captaingoldfish.scim.sdk.common.response.ListResponse;
import de.captaingoldfish.scim.sdk.common.response.ScimResponse;
import de.captaingoldfish.scim.sdk.common.response.UpdateResponse;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class ScimServerResponse<T extends ResourceNode> {
    private ScimResponse scimResponse;
    private T resource;
    private Class<T> resourceType;
    private ResponseType responseType;
    private ResponseException responseException;
    private Integer responseStatus;

    public ScimServerResponse(ScimResponse scimResponse, Class<T> responseEntityType, Integer responseStatus) {
        this.scimResponse = StringUtils.isBlank((CharSequence)scimResponse.toString()) || scimResponse.isEmpty() ? null : scimResponse;
        this.resourceType = responseEntityType;
        this.responseType = this.getResponseType(scimResponse);
        this.responseStatus = responseStatus;
    }

    public Optional<ScimResponse> getScimResponse() {
        return Optional.ofNullable(this.scimResponse);
    }

    public void setScimResponse(ScimResponse scimResponse) {
        this.scimResponse = scimResponse;
    }

    public Optional<T> getResource() {
        if (ResponseType.ERROR.equals((Object)this.responseType)) {
            return Optional.empty();
        }
        if (this.resource != null) {
            return Optional.of(this.resource);
        }
        if (this.responseType == null) {
            throw new IllegalStateException("no response type was set cannot translate response into a resource");
        }
        this.resource = (ResourceNode)JsonHelper.copyResourceToObject((JsonNode)this.scimResponse, this.resourceType);
        return Optional.ofNullable(this.resource);
    }

    public Optional<ResponseException> getErrorResponse() {
        if (this.responseException != null) {
            return Optional.of(this.responseException);
        }
        if (!ResponseType.ERROR.equals((Object)this.responseType)) {
            return Optional.empty();
        }
        ErrorResponse errorResponse = (ErrorResponse)this.scimResponse;
        this.responseException = new ResponseException((String)errorResponse.getDetail().orElse(null), Integer.valueOf(errorResponse.getStatus()), (String)errorResponse.getScimType().orElse(null));
        return Optional.of(this.responseException);
    }

    public Map<String, String> getHttpHeaders() {
        return this.scimResponse.getHttpHeaders();
    }

    public int getHttpStatus() {
        return this.responseStatus;
    }

    private ResponseType getResponseType(ScimResponse scimResponse) {
        if (scimResponse instanceof ErrorResponse) {
            return ResponseType.ERROR;
        }
        if (scimResponse instanceof CreateResponse) {
            return ResponseType.CREATE;
        }
        if (scimResponse instanceof GetResponse) {
            return ResponseType.READ;
        }
        if (scimResponse instanceof UpdateResponse) {
            return ResponseType.UPDATE;
        }
        if (scimResponse instanceof DeleteResponse) {
            return ResponseType.DELETE;
        }
        if (scimResponse instanceof ListResponse) {
            return ResponseType.LIST;
        }
        if (scimResponse instanceof BulkResponse) {
            return ResponseType.BULK;
        }
        throw new IllegalStateException("unreachable statement");
    }

    public static <T extends ResourceNode> ScimServerResponseBuilder<T> builder() {
        return new ScimServerResponseBuilder();
    }

    public ResponseType getResponseType() {
        return this.responseType;
    }

    public static class ScimServerResponseBuilder<T extends ResourceNode> {
        private ScimResponse scimResponse;
        private Class<T> responseEntityType;
        private Integer responseStatus;

        ScimServerResponseBuilder() {
        }

        public ScimServerResponseBuilder<T> scimResponse(ScimResponse scimResponse) {
            this.scimResponse = scimResponse;
            return this;
        }

        public ScimServerResponseBuilder<T> responseEntityType(Class<T> responseEntityType) {
            this.responseEntityType = responseEntityType;
            return this;
        }

        public ScimServerResponseBuilder<T> responseStatus(Integer responseStatus) {
            this.responseStatus = responseStatus;
            return this;
        }

        public ScimServerResponse<T> build() {
            return new ScimServerResponse<T>(this.scimResponse, this.responseEntityType, this.responseStatus);
        }

        public String toString() {
            return "ScimServerResponse.ScimServerResponseBuilder(scimResponse=" + this.scimResponse + ", responseEntityType=" + this.responseEntityType + ", responseStatus=" + this.responseStatus + ")";
        }
    }
}

