/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.client.keys;

import de.captaingoldfish.scim.sdk.client.exceptions.KeyStoreReadingException;
import de.captaingoldfish.scim.sdk.client.keys.KeyStoreSupporter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreWrapper {
    private static final Logger log = LoggerFactory.getLogger(KeyStoreWrapper.class);
    private static final String COULD_NOT_ACCESS_KEYSTORE = "could not access the given keystore";
    private KeyStore keyStore;
    private String keystorePassword;
    private Map<String, AliasPasswordPair> keystoreEntries = new HashMap<String, AliasPasswordPair>();

    public KeyStoreWrapper(KeyStore keyStore, String privateKeyPassword) {
        this.keyStore = keyStore;
        this.keystorePassword = privateKeyPassword;
    }

    public KeyStoreWrapper(byte[] keyStore, String keystorePassword) {
        this(keyStore, KeyStoreSupporter.KeyStoreType.JKS, keystorePassword);
    }

    public KeyStoreWrapper(byte[] keyStore, KeyStoreSupporter.KeyStoreType keyStoreType, String keystorePassword) {
        this(new ByteArrayInputStream(keyStore), keyStoreType, keystorePassword);
    }

    public KeyStoreWrapper(InputStream keyStore, String keystorePassword) {
        this(keyStore, KeyStoreSupporter.KeyStoreType.JKS, keystorePassword);
    }

    public KeyStoreWrapper(InputStream keyStore, KeyStoreSupporter.KeyStoreType keyStoreType, String keystorePassword) {
        this.keyStore = KeyStoreSupporter.readKeyStore(keyStore, keyStoreType, keystorePassword);
        this.keystorePassword = keystorePassword;
    }

    public KeyStoreWrapper(KeyStore keyStore, String keystorePassword, AliasPasswordPair aliasPasswordPair, AliasPasswordPair ... aliasPasswordPairs) {
        this(keyStore, keystorePassword);
        this.keystoreEntries.put(aliasPasswordPair.getAlias(), aliasPasswordPair);
        if (aliasPasswordPairs != null) {
            Arrays.stream(aliasPasswordPairs).forEach(app -> this.keystoreEntries.put(app.getAlias(), (AliasPasswordPair)app));
        }
    }

    public KeyStoreWrapper(byte[] keyStore, KeyStoreSupporter.KeyStoreType keyStoreType, String keystorePassword, AliasPasswordPair aliasPasswordPair, AliasPasswordPair ... aliasPasswordPairs) {
        this(KeyStoreSupporter.readKeyStore(keyStore, keyStoreType, keystorePassword), keystorePassword, aliasPasswordPair, aliasPasswordPairs);
        this.keystorePassword = keystorePassword;
    }

    public KeyStoreWrapper(InputStream keyStore, KeyStoreSupporter.KeyStoreType keyStoreType, String keystorePassword, AliasPasswordPair aliasPasswordPair, AliasPasswordPair ... aliasPasswordPairs) {
        this(KeyStoreSupporter.readKeyStore(keyStore, keyStoreType, keystorePassword), keystorePassword, aliasPasswordPair, aliasPasswordPairs);
        this.keystorePassword = keystorePassword;
    }

    public KeyStoreWrapper(File keyStore, String keystorePassword, AliasPasswordPair aliasPasswordPair, AliasPasswordPair ... aliasPasswordPairs) {
        this(KeyStoreSupporter.readKeyStore(keyStore, keystorePassword), keystorePassword, aliasPasswordPair, aliasPasswordPairs);
        this.keystorePassword = keystorePassword;
    }

    public Optional<PrivateKey> getPrivateKey(String alias) {
        if (this.keyStore == null || StringUtils.isBlank((CharSequence)alias)) {
            return Optional.empty();
        }
        AliasPasswordPair aliasPasswordPair = this.keystoreEntries.get(alias);
        try {
            PrivateKey privateKey = aliasPasswordPair == null ? (PrivateKey)this.keyStore.getKey(alias, this.keystorePassword.toCharArray()) : (PrivateKey)this.keyStore.getKey(alias, aliasPasswordPair.getKeyPassword().toCharArray());
            if (privateKey == null && log.isWarnEnabled()) {
                log.warn("no private key found for alias: {}", (Object)alias);
            }
            return Optional.ofNullable(privateKey);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new KeyStoreReadingException("could not read keystore entry with alias: " + alias, e);
        }
    }

    public Optional<PrivateKey> getPrivateKey(String alias, String password) {
        if (this.keyStore == null || StringUtils.isBlank((CharSequence)alias) || password == null) {
            return Optional.empty();
        }
        try {
            PrivateKey privateKey = (PrivateKey)this.keyStore.getKey(alias, password.toCharArray());
            if (privateKey == null && log.isWarnEnabled()) {
                log.warn("no private key found for alias: {}", (Object)alias);
            }
            return Optional.ofNullable(privateKey);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new KeyStoreReadingException("could not read keystore entry with alias: " + alias, e);
        }
    }

    public Optional<X509Certificate> getCertificate(String alias) {
        if (this.keyStore == null || StringUtils.isBlank((CharSequence)alias)) {
            return Optional.empty();
        }
        try {
            X509Certificate x509Certificate = (X509Certificate)this.keyStore.getCertificate(alias);
            if (x509Certificate == null && log.isWarnEnabled()) {
                log.warn("no certificate entry found for alias: {}", (Object)alias);
            }
            return Optional.ofNullable(x509Certificate);
        }
        catch (KeyStoreException e) {
            throw new KeyStoreReadingException("could not read certificate with alias: " + alias, e);
        }
    }

    public Optional<X509Certificate[]> getCertificateChain(String alias) {
        if (this.keyStore == null || StringUtils.isBlank((CharSequence)alias)) {
            return Optional.empty();
        }
        try {
            Certificate[] chain = this.keyStore.getCertificateChain(alias);
            if (chain == null && log.isWarnEnabled()) {
                log.warn("no certificate entry found for alias: {}", (Object)alias);
            }
            if (chain == null) {
                return Optional.empty();
            }
            X509Certificate[] x509Certificate = new X509Certificate[chain.length];
            for (int i = 0; i < chain.length; ++i) {
                x509Certificate[i] = (X509Certificate)chain[i];
            }
            return Optional.of(x509Certificate);
        }
        catch (KeyStoreException e) {
            throw new KeyStoreReadingException("could not read certificate with alias: " + alias, e);
        }
    }

    public List<String> getAliasesAsList() {
        if (this.keyStore == null) {
            throw new KeyStoreReadingException(COULD_NOT_ACCESS_KEYSTORE);
        }
        try {
            Enumeration<String> aliasEnumeration = this.keyStore.aliases();
            ArrayList<String> aliases = new ArrayList<String>();
            while (aliasEnumeration.hasMoreElements()) {
                aliases.add(aliasEnumeration.nextElement());
            }
            return aliases;
        }
        catch (KeyStoreException e) {
            throw new KeyStoreReadingException(COULD_NOT_ACCESS_KEYSTORE, e);
        }
    }

    public Enumeration<String> getAliases() {
        if (this.keyStore == null) {
            throw new KeyStoreReadingException(COULD_NOT_ACCESS_KEYSTORE);
        }
        try {
            return this.keyStore.aliases();
        }
        catch (KeyStoreException e) {
            throw new KeyStoreReadingException(COULD_NOT_ACCESS_KEYSTORE, e);
        }
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public Map<String, AliasPasswordPair> getKeystoreEntries() {
        return this.keystoreEntries;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public void setKeystoreEntries(Map<String, AliasPasswordPair> keystoreEntries) {
        this.keystoreEntries = keystoreEntries;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyStoreWrapper)) {
            return false;
        }
        KeyStoreWrapper other = (KeyStoreWrapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        KeyStore this$keyStore = this.getKeyStore();
        KeyStore other$keyStore = other.getKeyStore();
        if (this$keyStore == null ? other$keyStore != null : !this$keyStore.equals(other$keyStore)) {
            return false;
        }
        String this$keystorePassword = this.getKeystorePassword();
        String other$keystorePassword = other.getKeystorePassword();
        if (this$keystorePassword == null ? other$keystorePassword != null : !this$keystorePassword.equals(other$keystorePassword)) {
            return false;
        }
        Map<String, AliasPasswordPair> this$keystoreEntries = this.getKeystoreEntries();
        Map<String, AliasPasswordPair> other$keystoreEntries = other.getKeystoreEntries();
        return !(this$keystoreEntries == null ? other$keystoreEntries != null : !((Object)this$keystoreEntries).equals(other$keystoreEntries));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KeyStoreWrapper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        KeyStore $keyStore = this.getKeyStore();
        result = result * 59 + ($keyStore == null ? 43 : $keyStore.hashCode());
        String $keystorePassword = this.getKeystorePassword();
        result = result * 59 + ($keystorePassword == null ? 43 : $keystorePassword.hashCode());
        Map<String, AliasPasswordPair> $keystoreEntries = this.getKeystoreEntries();
        result = result * 59 + ($keystoreEntries == null ? 43 : ((Object)$keystoreEntries).hashCode());
        return result;
    }

    public String toString() {
        return "KeyStoreWrapper(keyStore=" + this.getKeyStore() + ", keystorePassword=" + this.getKeystorePassword() + ", keystoreEntries=" + this.getKeystoreEntries() + ")";
    }

    public static class AliasPasswordPair {
        private String alias;
        private String keyPassword;

        public static AliasPasswordPairBuilder builder() {
            return new AliasPasswordPairBuilder();
        }

        public String getAlias() {
            return this.alias;
        }

        public String getKeyPassword() {
            return this.keyPassword;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public void setKeyPassword(String keyPassword) {
            this.keyPassword = keyPassword;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AliasPasswordPair)) {
                return false;
            }
            AliasPasswordPair other = (AliasPasswordPair)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$alias = this.getAlias();
            String other$alias = other.getAlias();
            if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
                return false;
            }
            String this$keyPassword = this.getKeyPassword();
            String other$keyPassword = other.getKeyPassword();
            return !(this$keyPassword == null ? other$keyPassword != null : !this$keyPassword.equals(other$keyPassword));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AliasPasswordPair;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $alias = this.getAlias();
            result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
            String $keyPassword = this.getKeyPassword();
            result = result * 59 + ($keyPassword == null ? 43 : $keyPassword.hashCode());
            return result;
        }

        public String toString() {
            return "KeyStoreWrapper.AliasPasswordPair(alias=" + this.getAlias() + ", keyPassword=" + this.getKeyPassword() + ")";
        }

        public AliasPasswordPair(String alias, String keyPassword) {
            this.alias = alias;
            this.keyPassword = keyPassword;
        }

        public static class AliasPasswordPairBuilder {
            private String alias;
            private String keyPassword;

            AliasPasswordPairBuilder() {
            }

            public AliasPasswordPairBuilder alias(String alias) {
                this.alias = alias;
                return this;
            }

            public AliasPasswordPairBuilder keyPassword(String keyPassword) {
                this.keyPassword = keyPassword;
                return this;
            }

            public AliasPasswordPair build() {
                return new AliasPasswordPair(this.alias, this.keyPassword);
            }

            public String toString() {
                return "KeyStoreWrapper.AliasPasswordPair.AliasPasswordPairBuilder(alias=" + this.alias + ", keyPassword=" + this.keyPassword + ")";
            }
        }
    }
}

