/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.client.keys;

import de.captaingoldfish.scim.sdk.client.exceptions.CertificateCreationException;
import de.captaingoldfish.scim.sdk.client.exceptions.KeyGenerationException;
import de.captaingoldfish.scim.sdk.client.keys.SecurityProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyReader {
    private static final Logger log = LoggerFactory.getLogger(KeyReader.class);

    public static PrivateKey readPrivateRSAKey(byte[] privateKey) {
        if (log.isTraceEnabled()) {
            log.trace("trying to create private key. privateKey.length: {}-bytes", (Object)privateKey.length);
        }
        KeyFactory keyFactory = null;
        try {
            keyFactory = KeyFactory.getInstance("RSA", SecurityProvider.BOUNCY_CASTLE_PROVIDER);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyGenerationException("could not create private key since the RSA algorithm was not found.", e);
        }
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(privateKey);
        try {
            return keyFactory.generatePrivate(privateKeySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new KeyGenerationException("could not read a private rsa key from the given byte-array", e);
        }
    }

    public static PublicKey readPublicRSAKey(byte[] publicKey) {
        if (log.isTraceEnabled()) {
            log.trace("trying to create public key. publicKey.length: {}-bytes", (Object)publicKey.length);
        }
        KeyFactory keyFactory = null;
        try {
            keyFactory = KeyFactory.getInstance("RSA", SecurityProvider.BOUNCY_CASTLE_PROVIDER);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyGenerationException("could not create public key since the RSA algorithm was not found.", e);
        }
        try {
            return keyFactory.generatePublic(new X509EncodedKeySpec(publicKey));
        }
        catch (InvalidKeySpecException e) {
            throw new KeyGenerationException("could not read a public rsa key from the given byte-array", e);
        }
    }

    public static X509Certificate readX509Certificate(byte[] certificateBytes) {
        if (log.isTraceEnabled()) {
            log.trace("read X509 certificate. certificate.length: {}-bytes", (Object)certificateBytes.length);
        }
        return KeyReader.readX509Certificate(new ByteArrayInputStream(certificateBytes));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static X509Certificate readX509Certificate(InputStream certificateStream) {
        try (InputStream in = certificateStream;){
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509", SecurityProvider.BOUNCY_CASTLE_PROVIDER);
            X509Certificate x509Certificate = (X509Certificate)certFactory.generateCertificate(in);
            if (x509Certificate == null) {
                throw new CertificateCreationException("the byte-array does not seem to contain data of a X509 certificate.");
            }
            if (log.isTraceEnabled()) {
                log.trace("X509 certificate was successfully read.");
            }
            X509Certificate x509Certificate2 = x509Certificate;
            return x509Certificate2;
        }
        catch (IOException | CertificateException e) {
            throw new CertificateCreationException("was not able to create X509 certificate from byte-array", e);
        }
    }

    public static KeyPair generateNewRsaKeyPair(int keyLength) {
        KeyPairGenerator keyGenerator = null;
        try {
            keyGenerator = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("unknown algorithm", e);
        }
        keyGenerator.initialize(keyLength);
        return keyGenerator.generateKeyPair();
    }

    private KeyReader() {
    }
}

