/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.client.http;

import de.captaingoldfish.scim.sdk.client.http.ConfigManipulator;
import de.captaingoldfish.scim.sdk.client.http.HttpResponse;
import de.captaingoldfish.scim.sdk.client.http.ProxyHelper;
import de.captaingoldfish.scim.sdk.client.http.SSLContextHelper;
import de.captaingoldfish.scim.sdk.client.keys.KeyStoreWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import javax.net.ssl.HostnameVerifier;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScimHttpClient {
    private static final Logger log = LoggerFactory.getLogger(ScimHttpClient.class);
    private static final int TIMEOUT_MILLIS = 1000;
    private int connectTimeout;
    private int requestTimeout;
    private int socketTimeout;
    private ProxyHelper proxy;
    private KeyStoreWrapper tlsClientAuthenticatonKeystore;
    private KeyStoreWrapper truststore;
    private HostnameVerifier hostnameVerifier;
    private ConfigManipulator configManipulator;

    private static HttpResponse toResponse(CloseableHttpResponse response) throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        Arrays.stream(response.getAllHeaders()).forEach(header -> headers.put(header.getName(), header.getValue()));
        return HttpResponse.builder().httpStatusCode(response.getStatusLine().getStatusCode()).responseBody(response.getEntity() == null ? "" : IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8)).responseHeaders(headers).build();
    }

    public CloseableHttpClient getHttpClient() {
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        CredentialsProvider credentialsProvider = null;
        if (this.proxy != null && this.proxy.isProxySet()) {
            credentialsProvider = this.proxy.getProxyCredentials();
        }
        clientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        if (this.tlsClientAuthenticatonKeystore != null || this.truststore != null) {
            clientBuilder.setSSLContext(SSLContextHelper.getSslContext(this.tlsClientAuthenticatonKeystore, this.truststore));
        }
        clientBuilder.setConnectionReuseStrategy((response, context) -> false);
        if (this.hostnameVerifier != null) {
            clientBuilder.setSSLHostnameVerifier(this.hostnameVerifier);
        }
        clientBuilder.setDefaultRequestConfig(this.getRequestConfig());
        if (this.configManipulator != null) {
            this.configManipulator.modifyHttpClientConfig(clientBuilder);
        }
        return clientBuilder.build();
    }

    public RequestConfig getRequestConfig() {
        RequestConfig.Builder configBuilder;
        if (this.proxy == null) {
            configBuilder = RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT);
        } else {
            RequestConfig proxyConfig = this.proxy.getProxyConfig();
            configBuilder = RequestConfig.copy((RequestConfig)proxyConfig);
        }
        if (this.connectTimeout > 0) {
            configBuilder.setConnectTimeout(this.connectTimeout * 1000);
            log.debug("connection timeout '{}' seconds", (Object)this.connectTimeout);
        }
        if (this.socketTimeout > 0) {
            configBuilder.setSocketTimeout(this.socketTimeout * 1000);
            log.debug("socket timeout '{}' seconds", (Object)this.socketTimeout);
        }
        if (this.requestTimeout > 0) {
            configBuilder.setConnectionRequestTimeout(this.requestTimeout * 1000);
            log.debug("request timeout '{}' seconds", (Object)this.requestTimeout);
        }
        if (this.configManipulator != null) {
            this.configManipulator.modifyRequestConfig(configBuilder);
        }
        return configBuilder.build();
    }

    /*
     * Exception decompiling
     */
    public HttpResponse sendRequest(HttpUriRequest uriRequest) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    ScimHttpClient(int connectTimeout, int requestTimeout, int socketTimeout, ProxyHelper proxy, KeyStoreWrapper tlsClientAuthenticatonKeystore, KeyStoreWrapper truststore, HostnameVerifier hostnameVerifier, ConfigManipulator configManipulator) {
        this.connectTimeout = connectTimeout;
        this.requestTimeout = requestTimeout;
        this.socketTimeout = socketTimeout;
        this.proxy = proxy;
        this.tlsClientAuthenticatonKeystore = tlsClientAuthenticatonKeystore;
        this.truststore = truststore;
        this.hostnameVerifier = hostnameVerifier;
        this.configManipulator = configManipulator;
    }

    public static ScimHttpClientBuilder builder() {
        return new ScimHttpClientBuilder();
    }

    public static int getTIMEOUT_MILLIS() {
        return 1000;
    }

    public static class ScimHttpClientBuilder {
        private int connectTimeout;
        private int requestTimeout;
        private int socketTimeout;
        private ProxyHelper proxy;
        private KeyStoreWrapper tlsClientAuthenticatonKeystore;
        private KeyStoreWrapper truststore;
        private HostnameVerifier hostnameVerifier;
        private ConfigManipulator configManipulator;

        ScimHttpClientBuilder() {
        }

        public ScimHttpClientBuilder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public ScimHttpClientBuilder requestTimeout(int requestTimeout) {
            this.requestTimeout = requestTimeout;
            return this;
        }

        public ScimHttpClientBuilder socketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public ScimHttpClientBuilder proxy(ProxyHelper proxy) {
            this.proxy = proxy;
            return this;
        }

        public ScimHttpClientBuilder tlsClientAuthenticatonKeystore(KeyStoreWrapper tlsClientAuthenticatonKeystore) {
            this.tlsClientAuthenticatonKeystore = tlsClientAuthenticatonKeystore;
            return this;
        }

        public ScimHttpClientBuilder truststore(KeyStoreWrapper truststore) {
            this.truststore = truststore;
            return this;
        }

        public ScimHttpClientBuilder hostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
            return this;
        }

        public ScimHttpClientBuilder configManipulator(ConfigManipulator configManipulator) {
            this.configManipulator = configManipulator;
            return this;
        }

        public ScimHttpClient build() {
            return new ScimHttpClient(this.connectTimeout, this.requestTimeout, this.socketTimeout, this.proxy, this.tlsClientAuthenticatonKeystore, this.truststore, this.hostnameVerifier, this.configManipulator);
        }

        public String toString() {
            return "ScimHttpClient.ScimHttpClientBuilder(connectTimeout=" + this.connectTimeout + ", requestTimeout=" + this.requestTimeout + ", socketTimeout=" + this.socketTimeout + ", proxy=" + this.proxy + ", tlsClientAuthenticatonKeystore=" + this.tlsClientAuthenticatonKeystore + ", truststore=" + this.truststore + ", hostnameVerifier=" + this.hostnameVerifier + ", configManipulator=" + this.configManipulator + ")";
        }
    }
}

