/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.client.builder;

import de.captaingoldfish.scim.sdk.client.http.BasicAuth;
import de.captaingoldfish.scim.sdk.client.http.ConfigManipulator;
import de.captaingoldfish.scim.sdk.client.http.ProxyHelper;
import de.captaingoldfish.scim.sdk.client.keys.KeyStoreWrapper;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;

public class ScimClientConfig {
    protected static final int DEFAULT_TIMEOUT = 10;
    private int requestTimeout;
    private int socketTimeout;
    private int connectTimeout;
    private HostnameVerifier hostnameVerifier;
    private ProxyHelper proxy;
    private KeyStoreWrapper clientAuth;
    private KeyStoreWrapper truststore;
    private Map<String, String> httpHeaders;
    private BasicAuth basicAuth;
    private ConfigManipulator configManipulator;

    public ScimClientConfig(Integer requestTimeout, Integer socketTimeout, Integer connectTimeout, HostnameVerifier hostnameVerifier, ProxyHelper proxy, KeyStoreWrapper clientAuth, KeyStoreWrapper truststore, Map<String, String> httpHeaders, BasicAuth basicAuth, ConfigManipulator configManipulator) {
        this.requestTimeout = requestTimeout == null ? 10 : requestTimeout;
        this.socketTimeout = socketTimeout == null ? 10 : socketTimeout;
        this.connectTimeout = connectTimeout == null ? 10 : connectTimeout;
        this.hostnameVerifier = hostnameVerifier;
        this.proxy = proxy;
        this.clientAuth = clientAuth;
        this.truststore = truststore;
        this.httpHeaders = httpHeaders;
        this.basicAuth = basicAuth;
        this.configManipulator = configManipulator;
    }

    public static ScimClientConfigBuilder builder() {
        return new ScimClientConfigBuilder();
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public ProxyHelper getProxy() {
        return this.proxy;
    }

    public KeyStoreWrapper getClientAuth() {
        return this.clientAuth;
    }

    public KeyStoreWrapper getTruststore() {
        return this.truststore;
    }

    public Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    public BasicAuth getBasicAuth() {
        return this.basicAuth;
    }

    public ConfigManipulator getConfigManipulator() {
        return this.configManipulator;
    }

    public void setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public void setProxy(ProxyHelper proxy) {
        this.proxy = proxy;
    }

    public void setClientAuth(KeyStoreWrapper clientAuth) {
        this.clientAuth = clientAuth;
    }

    public void setTruststore(KeyStoreWrapper truststore) {
        this.truststore = truststore;
    }

    public void setHttpHeaders(Map<String, String> httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    public void setBasicAuth(BasicAuth basicAuth) {
        this.basicAuth = basicAuth;
    }

    public void setConfigManipulator(ConfigManipulator configManipulator) {
        this.configManipulator = configManipulator;
    }

    public ScimClientConfig() {
    }

    public static class ScimClientConfigBuilder {
        private Integer requestTimeout;
        private Integer socketTimeout;
        private Integer connectTimeout;
        private HostnameVerifier hostnameVerifier;
        private ProxyHelper proxy;
        private KeyStoreWrapper clientAuth;
        private KeyStoreWrapper truststore;
        private Map<String, String> httpHeaders;
        private BasicAuth basicAuth;
        private ConfigManipulator configManipulator;

        public ScimClientConfigBuilder basic(String username, String password) {
            this.basicAuth = BasicAuth.builder().username(username).password(password).build();
            return this;
        }

        ScimClientConfigBuilder() {
        }

        public ScimClientConfigBuilder requestTimeout(Integer requestTimeout) {
            this.requestTimeout = requestTimeout;
            return this;
        }

        public ScimClientConfigBuilder socketTimeout(Integer socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public ScimClientConfigBuilder connectTimeout(Integer connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public ScimClientConfigBuilder hostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
            return this;
        }

        public ScimClientConfigBuilder proxy(ProxyHelper proxy) {
            this.proxy = proxy;
            return this;
        }

        public ScimClientConfigBuilder clientAuth(KeyStoreWrapper clientAuth) {
            this.clientAuth = clientAuth;
            return this;
        }

        public ScimClientConfigBuilder truststore(KeyStoreWrapper truststore) {
            this.truststore = truststore;
            return this;
        }

        public ScimClientConfigBuilder httpHeaders(Map<String, String> httpHeaders) {
            this.httpHeaders = httpHeaders;
            return this;
        }

        public ScimClientConfigBuilder basicAuth(BasicAuth basicAuth) {
            this.basicAuth = basicAuth;
            return this;
        }

        public ScimClientConfigBuilder configManipulator(ConfigManipulator configManipulator) {
            this.configManipulator = configManipulator;
            return this;
        }

        public ScimClientConfig build() {
            return new ScimClientConfig(this.requestTimeout, this.socketTimeout, this.connectTimeout, this.hostnameVerifier, this.proxy, this.clientAuth, this.truststore, this.httpHeaders, this.basicAuth, this.configManipulator);
        }

        public String toString() {
            return "ScimClientConfig.ScimClientConfigBuilder(requestTimeout=" + this.requestTimeout + ", socketTimeout=" + this.socketTimeout + ", connectTimeout=" + this.connectTimeout + ", hostnameVerifier=" + this.hostnameVerifier + ", proxy=" + this.proxy + ", clientAuth=" + this.clientAuth + ", truststore=" + this.truststore + ", httpHeaders=" + this.httpHeaders + ", basicAuth=" + this.basicAuth + ", configManipulator=" + this.configManipulator + ")";
        }
    }
}

