/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.client.builder;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.client.builder.ScimClientConfig;
import de.captaingoldfish.scim.sdk.client.http.HttpResponse;
import de.captaingoldfish.scim.sdk.client.http.ScimHttpClient;
import de.captaingoldfish.scim.sdk.client.response.ScimServerResponse;
import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;
import de.captaingoldfish.scim.sdk.common.response.ScimResponse;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import org.apache.http.client.methods.HttpUriRequest;

public abstract class RequestBuilder<T extends ResourceNode> {
    private final String baseUrl;
    private final ScimClientConfig scimClientConfig;
    private String endpoint;
    private String resource;
    private Class<T> responseEntityType;

    public RequestBuilder(String baseUrl, ScimClientConfig scimClientConfig, Class<T> responseEntityType) {
        this.baseUrl = baseUrl;
        this.scimClientConfig = scimClientConfig;
        this.responseEntityType = responseEntityType;
    }

    protected RequestBuilder<T> setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    protected RequestBuilder<T> setResource(String resource) {
        this.resource = resource;
        return this;
    }

    protected RequestBuilder<T> setResource(JsonNode resource) {
        this.resource = resource.toString();
        return this;
    }

    protected abstract <T extends ScimResponse> Class<T> getResponseType(int var1);

    public ScimServerResponse<T> sendRequest() {
        ScimHttpClient scimHttpClient = ScimHttpClient.builder().connectTimeout(this.scimClientConfig.getConnectTimeout()).requestTimeout(this.scimClientConfig.getRequestTimeout()).socketTimeout(this.scimClientConfig.getSocketTimeout()).proxy(this.scimClientConfig.getProxy()).hostnameVerifier(this.scimClientConfig.getHostnameVerifier()).tlsClientAuthenticatonKeystore(this.scimClientConfig.getClientAuth()).truststore(this.scimClientConfig.getTruststore()).configManipulator(this.scimClientConfig.getConfigManipulator()).build();
        HttpUriRequest request = this.getHttpUriRequest();
        request.setHeader("Content-Type", "application/scim+json");
        if (this.scimClientConfig.getBasicAuth() != null) {
            request.setHeader("Authorization", this.scimClientConfig.getBasicAuth().getAuthorizationHeaderValue());
        }
        return this.handleResponse(scimHttpClient.sendRequest(request));
    }

    private ScimServerResponse<T> handleResponse(HttpResponse response) {
        ScimResponse scimResponse = (ScimResponse)JsonHelper.readJsonDocument((String)response.getResponseBody(), this.getResponseType(response.getHttpStatusCode()));
        response.getResponseHeaders().forEach(scimResponse.getHttpHeaders()::put);
        return ScimServerResponse.builder().scimResponse(scimResponse).responseEntityType(this.responseEntityType).responseStatus(response.getHttpStatusCode()).build();
    }

    protected abstract HttpUriRequest getHttpUriRequest();

    protected String getBaseUrl() {
        return this.baseUrl;
    }

    protected String getEndpoint() {
        return this.endpoint;
    }

    protected String getResource() {
        return this.resource;
    }

    protected Class<T> getResponseEntityType() {
        return this.responseEntityType;
    }
}

