/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.client.builder;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.client.builder.RequestBuilder;
import de.captaingoldfish.scim.sdk.client.builder.ScimClientConfig;
import de.captaingoldfish.scim.sdk.common.constants.enums.Comparator;
import de.captaingoldfish.scim.sdk.common.constants.enums.SortOrder;
import de.captaingoldfish.scim.sdk.common.request.SearchRequest;
import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;
import de.captaingoldfish.scim.sdk.common.response.ErrorResponse;
import de.captaingoldfish.scim.sdk.common.response.ListResponse;
import de.captaingoldfish.scim.sdk.common.response.ScimResponse;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

public class ListBuilder<T extends ResourceNode> {
    private final String baseUrl;
    private final ScimClientConfig scimClientConfig;
    private final Class<T> responseEntityType;
    private final Map<String, String> requestParameters = new HashMap<String, String>();

    public ListBuilder(String baseUrl, ScimClientConfig scimClientConfig, Class<T> responseEntityType) {
        this.baseUrl = baseUrl;
        this.scimClientConfig = scimClientConfig;
        this.responseEntityType = responseEntityType;
    }

    public ListBuilder<T> count(int count) {
        this.requestParameters.put("count", String.valueOf(count));
        return this;
    }

    public ListBuilder<T> startIndex(long startIndex) {
        this.requestParameters.put("startIndex", String.valueOf(startIndex));
        return this;
    }

    public ListBuilder<T> sortBy(String sortBy) {
        this.requestParameters.put("sortBy", sortBy);
        return this;
    }

    public ListBuilder<T> sortOrder(SortOrder sortOrder) {
        this.requestParameters.put("sortOrder", sortOrder.name().toLowerCase());
        return this;
    }

    public ListBuilder<T> attributes(String ... attributeNames) {
        if (attributeNames != null) {
            this.requestParameters.put("attributes", String.join((CharSequence)",", attributeNames));
        }
        return this;
    }

    public ListBuilder<T> excludedAttributes(String ... attributeNames) {
        if (attributeNames != null) {
            this.requestParameters.put("excludedAttributes", String.join((CharSequence)",", attributeNames));
        }
        return this;
    }

    public FilterBuilder<T> filter(String attributeName, Comparator comparator, String value) {
        return this.filter(false, attributeName, comparator, value);
    }

    public FilterBuilder<T> filter(boolean openParanthesis, String attributeName, Comparator comparator, String value) {
        return new FilterBuilder(this, attributeName, comparator, value, openParanthesis);
    }

    public ListBuilder<T> filter(String filter) {
        this.requestParameters.put("filter", filter);
        return this;
    }

    public ListBuilder<T> custom(String attributeName, String attribute) {
        this.requestParameters.put(attributeName, attribute);
        return this;
    }

    public GetRequestBuilder<T> get() {
        return new GetRequestBuilder(this);
    }

    public PostRequestBuilder<T> post() {
        return new PostRequestBuilder(this);
    }

    protected Map<String, String> getRequestParameters() {
        return this.requestParameters;
    }

    public class FilterBuilder<T extends ResourceNode> {
        private final ListBuilder<T> listBuilder;
        private final StringBuilder filterString = new StringBuilder();
        private int openedParenthesis = 0;
        private int closedParenthesis = 0;

        public FilterBuilder(ListBuilder<T> listBuilder, String attributeName, Comparator comparator, String value, boolean openParenthesis) {
            this.listBuilder = listBuilder;
            this.openParenthesis(openParenthesis);
            this.setExpression(attributeName, comparator, value);
        }

        private FilterBuilder<T> openParenthesis(boolean openParenthesis) {
            if (openParenthesis) {
                ++this.openedParenthesis;
                this.filterString.append("(");
            }
            return this;
        }

        public FilterBuilder<T> closeParenthesis() {
            ++this.closedParenthesis;
            this.filterString.append(")");
            return this;
        }

        private FilterBuilder<T> closeParenthesis(boolean closeParenthesis) {
            if (closeParenthesis) {
                return this.closeParenthesis();
            }
            return this;
        }

        public FilterBuilder<T> and(String attributeName, Comparator comparator, String value) {
            return this.and(false, attributeName, comparator, value);
        }

        public FilterBuilder<T> or(String attributeName, Comparator comparator, String value) {
            return this.or(false, attributeName, comparator, value);
        }

        public FilterBuilder<T> and(String attributeName, Comparator comparator, Boolean value) {
            return this.and(false, attributeName, comparator, value);
        }

        public FilterBuilder<T> or(String attributeName, Comparator comparator, Boolean value) {
            return this.or(false, attributeName, comparator, value);
        }

        public FilterBuilder<T> and(String attributeName, Comparator comparator, Integer value) {
            return this.and(false, attributeName, comparator, value);
        }

        public FilterBuilder<T> or(String attributeName, Comparator comparator, Integer value) {
            return this.or(false, attributeName, comparator, value);
        }

        public FilterBuilder<T> and(String attributeName, Comparator comparator, Long value) {
            return this.and(false, attributeName, comparator, value);
        }

        public FilterBuilder<T> or(String attributeName, Comparator comparator, Long value) {
            return this.or(false, attributeName, comparator, value);
        }

        public FilterBuilder<T> and(String attributeName, Comparator comparator, Double value) {
            return this.and(false, attributeName, comparator, value);
        }

        public FilterBuilder<T> or(String attributeName, Comparator comparator, Double value) {
            return this.or(false, attributeName, comparator, value);
        }

        public FilterBuilder<T> and(String attributeName, Comparator comparator, Instant value) {
            return this.and(false, attributeName, comparator, value);
        }

        public FilterBuilder<T> or(String attributeName, Comparator comparator, Instant value) {
            return this.or(false, attributeName, comparator, value);
        }

        public FilterBuilder<T> and(boolean openParenthesis, String attributeName, Comparator comparator, String value) {
            return this.and(openParenthesis, attributeName, comparator, value, false);
        }

        public FilterBuilder<T> or(boolean openParenthesis, String attributeName, Comparator comparator, String value) {
            return this.or(openParenthesis, attributeName, comparator, value, false);
        }

        public FilterBuilder<T> and(boolean openParenthesis, String attributeName, Comparator comparator, Boolean value) {
            return this.and(openParenthesis, attributeName, comparator, value, false);
        }

        public FilterBuilder<T> or(boolean openParenthesis, String attributeName, Comparator comparator, Boolean value) {
            return this.or(openParenthesis, attributeName, comparator, value, false);
        }

        public FilterBuilder<T> and(boolean openParenthesis, String attributeName, Comparator comparator, Integer value) {
            return this.and(openParenthesis, attributeName, comparator, value, false);
        }

        public FilterBuilder<T> or(boolean openParenthesis, String attributeName, Comparator comparator, Integer value) {
            return this.or(openParenthesis, attributeName, comparator, value, false);
        }

        public FilterBuilder<T> and(boolean openParenthesis, String attributeName, Comparator comparator, Long value) {
            return this.and(openParenthesis, attributeName, comparator, value, false);
        }

        public FilterBuilder<T> or(boolean openParenthesis, String attributeName, Comparator comparator, Long value) {
            return this.or(openParenthesis, attributeName, comparator, value, false);
        }

        public FilterBuilder<T> and(boolean openParenthesis, String attributeName, Comparator comparator, Double value) {
            return this.and(openParenthesis, attributeName, comparator, value, false);
        }

        public FilterBuilder<T> or(boolean openParenthesis, String attributeName, Comparator comparator, Double value) {
            return this.or(openParenthesis, attributeName, comparator, value, false);
        }

        public FilterBuilder<T> and(boolean openParenthesis, String attributeName, Comparator comparator, Instant value) {
            return this.and(openParenthesis, attributeName, comparator, value, false);
        }

        public FilterBuilder<T> or(boolean openParenthesis, String attributeName, Comparator comparator, Instant value) {
            return this.or(openParenthesis, attributeName, comparator, value, false);
        }

        public FilterBuilder<T> and(String attributeName, Comparator comparator, String value, boolean closeParenthesis) {
            return this.and(false, attributeName, comparator, value, closeParenthesis);
        }

        public FilterBuilder<T> or(String attributeName, Comparator comparator, String value, boolean closeParenthesis) {
            return this.or(false, attributeName, comparator, value, closeParenthesis);
        }

        public FilterBuilder<T> and(String attributeName, Comparator comparator, Boolean value, boolean closeParenthesis) {
            return this.and(false, attributeName, comparator, value, closeParenthesis);
        }

        public FilterBuilder<T> or(String attributeName, Comparator comparator, Boolean value, boolean closeParenthesis) {
            return this.or(false, attributeName, comparator, value, closeParenthesis);
        }

        public FilterBuilder<T> and(String attributeName, Comparator comparator, Integer value, boolean closeParenthesis) {
            return this.and(false, attributeName, comparator, value, closeParenthesis);
        }

        public FilterBuilder<T> or(String attributeName, Comparator comparator, Integer value, boolean closeParenthesis) {
            return this.or(false, attributeName, comparator, value, closeParenthesis);
        }

        public FilterBuilder<T> and(String attributeName, Comparator comparator, Long value, boolean closeParenthesis) {
            return this.and(false, attributeName, comparator, value, closeParenthesis);
        }

        public FilterBuilder<T> or(String attributeName, Comparator comparator, Long value, boolean closeParenthesis) {
            return this.or(false, attributeName, comparator, value, closeParenthesis);
        }

        public FilterBuilder<T> and(String attributeName, Comparator comparator, Double value, boolean closeParenthesis) {
            return this.and(false, attributeName, comparator, value, closeParenthesis);
        }

        public FilterBuilder<T> or(String attributeName, Comparator comparator, Double value, boolean closeParenthesis) {
            return this.or(false, attributeName, comparator, value, closeParenthesis);
        }

        public FilterBuilder<T> and(String attributeName, Comparator comparator, Instant value, boolean closeParenthesis) {
            return this.and(false, attributeName, comparator, value, closeParenthesis);
        }

        public FilterBuilder<T> or(String attributeName, Comparator comparator, Instant value, boolean closeParenthesis) {
            return this.or(false, attributeName, comparator, value, closeParenthesis);
        }

        public FilterBuilder<T> and(boolean openParenthesis, String attributeName, Comparator comparator, String value, boolean closeParenthesis) {
            this.filterString.append(" and ");
            this.openParenthesis(openParenthesis);
            this.setExpression(attributeName, comparator, value);
            this.closeParenthesis(closeParenthesis);
            return this;
        }

        public FilterBuilder<T> or(boolean openParenthesis, String attributeName, Comparator comparator, String value, boolean closeParenthesis) {
            this.filterString.append(" or ");
            this.openParenthesis(openParenthesis);
            this.setExpression(attributeName, comparator, value);
            this.closeParenthesis(closeParenthesis);
            return this;
        }

        public FilterBuilder<T> and(boolean openParenthesis, String attributeName, Comparator comparator, Boolean value, boolean closeParenthesis) {
            this.filterString.append(" and ");
            this.openParenthesis(openParenthesis);
            this.setExpression(attributeName, comparator, value);
            this.closeParenthesis(closeParenthesis);
            return this;
        }

        public FilterBuilder<T> or(boolean openParenthesis, String attributeName, Comparator comparator, Boolean value, boolean closeParenthesis) {
            this.filterString.append(" or ");
            this.openParenthesis(openParenthesis);
            this.setExpression(attributeName, comparator, value);
            this.closeParenthesis(closeParenthesis);
            return this;
        }

        public FilterBuilder<T> and(boolean openParenthesis, String attributeName, Comparator comparator, Integer value, boolean closeParenthesis) {
            this.filterString.append(" and ");
            this.openParenthesis(openParenthesis);
            this.setExpression(attributeName, comparator, value);
            this.closeParenthesis(closeParenthesis);
            return this;
        }

        public FilterBuilder<T> or(boolean openParenthesis, String attributeName, Comparator comparator, Integer value, boolean closeParenthesis) {
            this.filterString.append(" or ");
            this.openParenthesis(openParenthesis);
            this.setExpression(attributeName, comparator, value);
            this.closeParenthesis(closeParenthesis);
            return this;
        }

        public FilterBuilder<T> and(boolean openParenthesis, String attributeName, Comparator comparator, Long value, boolean closeParenthesis) {
            this.filterString.append(" and ");
            this.openParenthesis(openParenthesis);
            this.setExpression(attributeName, comparator, value);
            this.closeParenthesis(closeParenthesis);
            return this;
        }

        public FilterBuilder<T> or(boolean openParenthesis, String attributeName, Comparator comparator, Long value, boolean closeParenthesis) {
            this.filterString.append(" or ");
            this.openParenthesis(openParenthesis);
            this.setExpression(attributeName, comparator, value);
            this.closeParenthesis(closeParenthesis);
            return this;
        }

        public FilterBuilder<T> and(boolean openParenthesis, String attributeName, Comparator comparator, Double value, boolean closeParenthesis) {
            this.filterString.append(" and ");
            this.openParenthesis(openParenthesis);
            this.setExpression(attributeName, comparator, value);
            this.closeParenthesis(closeParenthesis);
            return this;
        }

        public FilterBuilder<T> or(boolean openParenthesis, String attributeName, Comparator comparator, Double value, boolean closeParenthesis) {
            this.filterString.append(" or ");
            this.openParenthesis(openParenthesis);
            this.setExpression(attributeName, comparator, value);
            this.closeParenthesis(closeParenthesis);
            return this;
        }

        public FilterBuilder<T> and(boolean openParenthesis, String attributeName, Comparator comparator, Instant value, boolean closeParenthesis) {
            this.filterString.append(" and ");
            this.openParenthesis(openParenthesis);
            this.setExpression(attributeName, comparator, value.toString());
            this.closeParenthesis(closeParenthesis);
            return this;
        }

        public FilterBuilder<T> or(boolean openParenthesis, String attributeName, Comparator comparator, Instant value, boolean closeParenthesis) {
            this.filterString.append(" or ");
            this.openParenthesis(openParenthesis);
            this.setExpression(attributeName, comparator, value.toString());
            this.closeParenthesis(closeParenthesis);
            return this;
        }

        private void setExpression(String attributeName, Comparator comparator, Object value) {
            this.filterString.append(attributeName).append(" ").append(comparator.name());
            if (value instanceof String) {
                this.filterString.append(value == null ? "" : " ").append("\"").append(value == null ? "" : value).append("\"");
            } else {
                this.filterString.append(value == null ? "" : " " + value);
            }
        }

        public ListBuilder<T> build() {
            if (this.openedParenthesis != this.closedParenthesis) {
                throw new IllegalStateException("error within filter expression\n\topened parentheses: " + this.openedParenthesis + "\n\tclosed parentheses: " + this.closedParenthesis + "\n\tfilter: " + this.filterString.toString());
            }
            ((ListBuilder)this.listBuilder).requestParameters.put("filter", this.filterString.toString());
            return this.listBuilder;
        }
    }

    public static class PostRequestBuilder<T extends ResourceNode>
    extends RequestBuilder<T> {
        private ListBuilder<T> listBuilder;

        public PostRequestBuilder(ListBuilder<T> listBuilder) {
            super(((ListBuilder)listBuilder).baseUrl, ((ListBuilder)listBuilder).scimClientConfig, ((ListBuilder)listBuilder).responseEntityType);
            this.listBuilder = listBuilder;
        }

        @Override
        public RequestBuilder<T> setEndpoint(String endpoint) {
            return super.setEndpoint(endpoint);
        }

        @Override
        protected <T1 extends ScimResponse> Class<T1> getResponseType(int responseCode) {
            return responseCode == 200 ? ListResponse.class : ErrorResponse.class;
        }

        @Override
        protected HttpUriRequest getHttpUriRequest() {
            HttpPost httpPost = new HttpPost(this.getBaseUrl() + this.getEndpoint() + "/.search");
            if (!((ListBuilder)this.listBuilder).requestParameters.isEmpty()) {
                SearchRequest searchRequest = SearchRequest.builder().build();
                ((ListBuilder)this.listBuilder).requestParameters.forEach((arg_0, arg_1) -> ((SearchRequest)searchRequest).put(arg_0, arg_1));
                super.setResource((JsonNode)searchRequest);
                StringEntity stringEntity = new StringEntity(this.getResource(), StandardCharsets.UTF_8);
                httpPost.setEntity((HttpEntity)stringEntity);
            }
            return httpPost;
        }
    }

    public static class GetRequestBuilder<T extends ResourceNode>
    extends RequestBuilder<T> {
        private ListBuilder<T> listBuilder;

        public GetRequestBuilder(ListBuilder<T> listBuilder) {
            super(((ListBuilder)listBuilder).baseUrl, ((ListBuilder)listBuilder).scimClientConfig, ((ListBuilder)listBuilder).responseEntityType);
            this.listBuilder = listBuilder;
        }

        @Override
        public RequestBuilder<T> setEndpoint(String endpoint) {
            return super.setEndpoint(endpoint);
        }

        @Override
        protected <T1 extends ScimResponse> Class<T1> getResponseType(int responseCode) {
            return responseCode == 200 ? ListResponse.class : ErrorResponse.class;
        }

        @Override
        protected HttpUriRequest getHttpUriRequest() {
            StringBuilder queryBuilder = new StringBuilder();
            if (!((ListBuilder)this.listBuilder).requestParameters.isEmpty()) {
                queryBuilder.append("?");
                ArrayList pairs = new ArrayList();
                ((ListBuilder)this.listBuilder).requestParameters.forEach((key, value) -> {
                    try {
                        pairs.add(key + "=" + URLEncoder.encode(value, StandardCharsets.UTF_8.name()));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new IllegalStateException(e.getMessage(), e);
                    }
                });
                queryBuilder.append(String.join((CharSequence)"&", pairs));
            }
            return new HttpGet(this.getBaseUrl() + this.getEndpoint() + queryBuilder.toString());
        }
    }
}

