/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.client.builder;

import de.captaingoldfish.scim.sdk.client.builder.ETagRequestBuilder;
import de.captaingoldfish.scim.sdk.client.builder.ScimClientConfig;
import de.captaingoldfish.scim.sdk.common.etag.ETag;
import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;
import de.captaingoldfish.scim.sdk.common.response.ErrorResponse;
import de.captaingoldfish.scim.sdk.common.response.GetResponse;
import de.captaingoldfish.scim.sdk.common.response.ScimResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

public class GetBuilder<T extends ResourceNode>
extends ETagRequestBuilder<T> {
    private String id;

    public GetBuilder(String baseUrl, ScimClientConfig scimClientConfig, Class<T> responseEntityType) {
        super(baseUrl, scimClientConfig, responseEntityType);
    }

    public GetBuilder<T> setId(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalStateException("id must not be blank for get-requests");
        }
        this.id = id;
        return this;
    }

    @Override
    public GetBuilder<T> setEndpoint(String endpoint) {
        return (GetBuilder)super.setEndpoint(endpoint);
    }

    @Override
    public GetBuilder<T> setETagForIfMatch(String version) {
        return (GetBuilder)super.setETagForIfMatch(version);
    }

    @Override
    public GetBuilder<T> setETagForIfNoneMatch(String version) {
        return (GetBuilder)super.setETagForIfNoneMatch(version);
    }

    @Override
    public GetBuilder<T> setETagForIfMatch(ETag version) {
        return (GetBuilder)super.setETagForIfMatch(version);
    }

    @Override
    public GetBuilder<T> setETagForIfNoneMatch(ETag version) {
        return (GetBuilder)super.setETagForIfNoneMatch(version);
    }

    @Override
    protected <T1 extends ScimResponse> Class<T1> getResponseType(int responseCode) {
        return 200 == responseCode ? GetResponse.class : ErrorResponse.class;
    }

    @Override
    protected HttpUriRequest getHttpUriRequest() {
        if (StringUtils.isBlank((CharSequence)this.id)) {
            throw new IllegalStateException("id must not be blank for get-requests");
        }
        HttpGet httpGet = new HttpGet(this.getBaseUrl() + this.getEndpoint() + "/" + this.id);
        if (this.isUseIfMatch()) {
            httpGet.setHeader("If-Match", this.getVersion().toString());
        }
        if (this.isUseIfNoneMatch()) {
            httpGet.setHeader("If-None-Match", this.getVersion().toString());
        }
        return httpGet;
    }
}

