/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.client.builder;

import de.captaingoldfish.scim.sdk.client.builder.ETagRequestBuilder;
import de.captaingoldfish.scim.sdk.client.builder.ScimClientConfig;
import de.captaingoldfish.scim.sdk.common.etag.ETag;
import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;
import de.captaingoldfish.scim.sdk.common.response.DeleteResponse;
import de.captaingoldfish.scim.sdk.common.response.ErrorResponse;
import de.captaingoldfish.scim.sdk.common.response.ScimResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpUriRequest;

public class DeleteBuilder<T extends ResourceNode>
extends ETagRequestBuilder<T> {
    private String id;

    public DeleteBuilder(String baseUrl, ScimClientConfig scimClientConfig, Class<T> responseEntityType) {
        super(baseUrl, scimClientConfig, responseEntityType);
    }

    public DeleteBuilder<T> setId(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalStateException("id must not be blank for delete-requests");
        }
        this.id = id;
        return this;
    }

    @Override
    public DeleteBuilder<T> setEndpoint(String endpoint) {
        return (DeleteBuilder)super.setEndpoint(endpoint);
    }

    @Override
    public DeleteBuilder<T> setETagForIfMatch(String version) {
        return (DeleteBuilder)super.setETagForIfMatch(version);
    }

    @Override
    public DeleteBuilder<T> setETagForIfNoneMatch(String version) {
        return (DeleteBuilder)super.setETagForIfNoneMatch(version);
    }

    @Override
    public DeleteBuilder<T> setETagForIfMatch(ETag version) {
        return (DeleteBuilder)super.setETagForIfMatch(version);
    }

    @Override
    public DeleteBuilder<T> setETagForIfNoneMatch(ETag version) {
        return (DeleteBuilder)super.setETagForIfNoneMatch(version);
    }

    @Override
    protected <T1 extends ScimResponse> Class<T1> getResponseType(int responseCode) {
        return 204 == responseCode ? DeleteResponse.class : ErrorResponse.class;
    }

    @Override
    protected HttpUriRequest getHttpUriRequest() {
        if (StringUtils.isBlank((CharSequence)this.id)) {
            throw new IllegalStateException("id must not be blank for delete-requests");
        }
        HttpDelete httpDelete = new HttpDelete(this.getBaseUrl() + this.getEndpoint() + "/" + this.id);
        if (this.isUseIfMatch()) {
            httpDelete.setHeader("If-Match", this.getVersion().toString());
        }
        if (this.isUseIfNoneMatch()) {
            httpDelete.setHeader("If-None-Match", this.getVersion().toString());
        }
        return httpDelete;
    }
}

