/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.client;

import de.captaingoldfish.scim.sdk.client.builder.CreateBuilder;
import de.captaingoldfish.scim.sdk.client.builder.DeleteBuilder;
import de.captaingoldfish.scim.sdk.client.builder.GetBuilder;
import de.captaingoldfish.scim.sdk.client.builder.ListBuilder;
import de.captaingoldfish.scim.sdk.client.builder.ScimClientConfig;
import de.captaingoldfish.scim.sdk.client.builder.UpdateBuilder;
import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;

public class ScimRequestBuilder {
    private final String baseUrl;
    private final ScimClientConfig scimClientConfig;

    public ScimRequestBuilder(String baseUrl, ScimClientConfig scimClientConfig) {
        this.baseUrl = baseUrl.replaceFirst("/$", "");
        this.scimClientConfig = scimClientConfig;
    }

    public <T extends ResourceNode> CreateBuilder<T> create(Class<T> type) {
        return new CreateBuilder<T>(this.baseUrl, this.scimClientConfig, type);
    }

    public <T extends ResourceNode> GetBuilder<T> get(Class<T> type) {
        return new GetBuilder<T>(this.baseUrl, this.scimClientConfig, type);
    }

    public <T extends ResourceNode> DeleteBuilder<T> delete(Class<T> type) {
        return new DeleteBuilder<T>(this.baseUrl, this.scimClientConfig, type);
    }

    public <T extends ResourceNode> UpdateBuilder<T> update(Class<T> type) {
        return new UpdateBuilder<T>(this.baseUrl, this.scimClientConfig, type);
    }

    public <T extends ResourceNode> ListBuilder<T> list(Class<T> type) {
        return new ListBuilder<T>(this.baseUrl, this.scimClientConfig, type);
    }

    public ScimClientConfig getScimClientConfig() {
        return this.scimClientConfig;
    }
}

