// Generated by delombok at Tue Nov 04 13:11:14 CET 2025
package de.captaingoldfish.scim.sdk.client.resources;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import de.captaingoldfish.scim.sdk.common.constants.AttributeNames;
import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import de.captaingoldfish.scim.sdk.common.resources.complex.Meta;


/**
 * Specifies the schema that describes a SCIM resource type
 */
public class ResourceType extends ResourceNode
{

  public ResourceType()
  {
    setSchemas(Arrays.asList(FieldNames.SCHEMA));
  }

  public ResourceType(String id,
                      Meta meta,
                      String name,
                      String description,
                      String endpoint,
                      String schema,
                      List<SchemaExtensions> schemaExtensions)
  {
    setSchemas(Arrays.asList(FieldNames.SCHEMA));
    setId(id);
    setMeta(meta);
    setName(name);
    setDescription(description);
    setEndpoint(endpoint);
    setSchema(schema);
    setSchemaExtensions(schemaExtensions);
  }

  /**
   * The resource type name. When applicable, service providers MUST specify the name, e.g., 'User'.
   */
  public String getName()
  {
    return getStringAttribute(FieldNames.NAME).get();
  }

  /**
   * The resource type name. When applicable, service providers MUST specify the name, e.g., 'User'.
   */
  public void setName(String name)
  {
    setAttribute(FieldNames.NAME, name);
  }

  /**
   * The resource type's human-readable description. When applicable, service providers MUST specify the
   * description.
   */
  public Optional<String> getDescription()
  {
    return getStringAttribute(FieldNames.DESCRIPTION);
  }

  /**
   * The resource type's human-readable description. When applicable, service providers MUST specify the
   * description.
   */
  public void setDescription(String description)
  {
    setAttribute(FieldNames.DESCRIPTION, description);
  }

  /**
   * The resource type's HTTP-addressable endpoint relative to the Base URL, e.g., '/Users'.
   */
  public String getEndpoint()
  {
    return getStringAttribute(FieldNames.ENDPOINT).get();
  }

  /**
   * The resource type's HTTP-addressable endpoint relative to the Base URL, e.g., '/Users'.
   */
  public void setEndpoint(String endpoint)
  {
    setAttribute(FieldNames.ENDPOINT, endpoint);
  }

  /**
   * The resource type's primary/base schema URI.
   */
  public String getSchema()
  {
    return getStringAttribute(AttributeNames.RFC7643.SCHEMA).get();
  }

  /**
   * The resource type's primary/base schema URI.
   */
  public void setSchema(String schema)
  {
    setAttribute(AttributeNames.RFC7643.SCHEMA, schema);
  }

  /**
   * A list of URIs of the resource type's schema extensions.
   */
  public List<SchemaExtensions> getSchemaExtensions()
  {
    return getArrayAttribute(FieldNames.SCHEMAEXTENSIONS, SchemaExtensions.class);
  }

  /**
   * A list of URIs of the resource type's schema extensions.
   */
  public void setSchemaExtensions(List<SchemaExtensions> schemaExtensions)
  {
    setAttribute(FieldNames.SCHEMAEXTENSIONS, schemaExtensions);
  }


  /**
   * A list of URIs of the resource type's schema extensions.
   */
  public static class SchemaExtensions extends ScimObjectNode
  {

    public SchemaExtensions()
    {}

    public SchemaExtensions(String schema, String required)
    {
      setSchema(schema);
      setRequired(required);
    }

    /**
     * The URI of a schema extension.
     */
    public String getSchema()
    {
      return getStringAttribute(AttributeNames.RFC7643.SCHEMA).get();
    }

    /**
     * The URI of a schema extension.
     */
    public void setSchema(String schema)
    {
      setAttribute(AttributeNames.RFC7643.SCHEMA, schema);
    }

    /**
     * A Boolean value that specifies whether or not the schema extension is required for the resource type. If
     * true, a resource of this type MUST include this schema extension and also include any attributes declared
     * as required in this schema extension. If false, a resource of this type MAY omit this schema extension.
     */
    public String getRequired()
    {
      return getStringAttribute(FieldNames.REQUIRED).get();
    }

    /**
     * A Boolean value that specifies whether or not the schema extension is required for the resource type. If
     * true, a resource of this type MUST include this schema extension and also include any attributes declared
     * as required in this schema extension. If false, a resource of this type MAY omit this schema extension.
     */
    public void setRequired(String required)
    {
      setAttribute(FieldNames.REQUIRED, required);
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static class SchemaExtensionsBuilder
    {

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      private String schema;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      private String required;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      SchemaExtensionsBuilder()
      {}

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public ResourceType.SchemaExtensions.SchemaExtensionsBuilder schema(final String schema)
      {
        this.schema = schema;
        return this;
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public ResourceType.SchemaExtensions.SchemaExtensionsBuilder required(final String required)
      {
        this.required = required;
        return this;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public ResourceType.SchemaExtensions build()
      {
        return new ResourceType.SchemaExtensions(this.schema, this.required);
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public java.lang.String toString()
      {
        return "ResourceType.SchemaExtensions.SchemaExtensionsBuilder(schema=" + this.schema + ", required="
               + this.required + ")";
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static ResourceType.SchemaExtensions.SchemaExtensionsBuilder builder()
    {
      return new ResourceType.SchemaExtensions.SchemaExtensionsBuilder();
    }
  }


  /**
   * contains the attribute names of the resource representation
   */
  public static class FieldNames
  {

    public static final String SCHEMA = "urn:ietf:params:scim:schemas:core:2.0:ResourceType";

    public static final String NAME = "name";

    public static final String DESCRIPTION = "description";

    public static final String ENDPOINT = "endpoint";

    public static final String SCHEMAEXTENSIONS = "schemaExtensions";

    public static final String REQUIRED = "required";
  }


  /**
   * override lombok builder with public constructor
   */
  public static class ResourceTypeBuilder
  {

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String id;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Meta meta;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String name;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String description;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String endpoint;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String schema;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private List<SchemaExtensions> schemaExtensions;

    public ResourceTypeBuilder()
    {}

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ResourceType.ResourceTypeBuilder id(final String id)
    {
      this.id = id;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ResourceType.ResourceTypeBuilder meta(final Meta meta)
    {
      this.meta = meta;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ResourceType.ResourceTypeBuilder name(final String name)
    {
      this.name = name;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ResourceType.ResourceTypeBuilder description(final String description)
    {
      this.description = description;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ResourceType.ResourceTypeBuilder endpoint(final String endpoint)
    {
      this.endpoint = endpoint;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ResourceType.ResourceTypeBuilder schema(final String schema)
    {
      this.schema = schema;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ResourceType.ResourceTypeBuilder schemaExtensions(final List<SchemaExtensions> schemaExtensions)
    {
      this.schemaExtensions = schemaExtensions;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ResourceType build()
    {
      return new ResourceType(this.id, this.meta, this.name, this.description, this.endpoint, this.schema,
                              this.schemaExtensions);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString()
    {
      return "ResourceType.ResourceTypeBuilder(id=" + this.id + ", meta=" + this.meta + ", name=" + this.name
             + ", description=" + this.description + ", endpoint=" + this.endpoint + ", schema=" + this.schema
             + ", schemaExtensions=" + this.schemaExtensions + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static ResourceType.ResourceTypeBuilder builder()
  {
    return new ResourceType.ResourceTypeBuilder();
  }
}
