// Generated by delombok at Tue Nov 04 13:11:14 CET 2025
package de.captaingoldfish.scim.sdk.client.resources;

import java.util.List;
import de.captaingoldfish.scim.sdk.common.constants.AttributeNames;
import de.captaingoldfish.scim.sdk.common.resources.ServiceProvider;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import de.captaingoldfish.scim.sdk.common.schemas.Schema;


/**
 * @author Pascal Knueppel
 * @since 14.10.2023
 */
public class MetaConfiguration extends ScimObjectNode
{

  public MetaConfiguration(ServiceProvider serviceProvider, List<ResourceType> resourceTypes, List<Schema> schemas)
  {
    setServiceProvider(serviceProvider);
    setResourceTypes(resourceTypes);
    setSchemas(schemas);
  }

  /**
   * the ServiceProvider config of a SCIM provider
   */
  public ServiceProvider getServiceProvider()
  {
    return getObjectAttribute(AttributeNames.Custom.SERVICE_PROVIDER, ServiceProvider.class).orElse(null);
  }

  /**
   * the ServiceProvider config of a SCIM provider
   */
  public void setServiceProvider(ServiceProvider serviceProvider)
  {
    setAttribute(AttributeNames.Custom.SERVICE_PROVIDER, serviceProvider);
  }

  /**
   * The resourceTypes of a SCIM provider that define the supported endpoints at the provider
   */
  public List<ResourceType> getResourceTypes()
  {
    return getArrayAttribute(AttributeNames.Custom.RESOURCE_TYPES, ResourceType.class);
  }

  /**
   * The resourceTypes of a SCIM provider that define the supported endpoints at the provider
   */
  public void setResourceTypes(List<ResourceType> resourceTypes)
  {
    setAttribute(AttributeNames.Custom.RESOURCE_TYPES, resourceTypes);
  }

  /**
   * The schemas of a SCIM provider that define the supported resources at the provider
   */
  public List<Schema> getSchemas()
  {
    return getArrayAttribute(AttributeNames.RFC7643.SCHEMAS, Schema.class);
  }

  /**
   * The schemas of a SCIM provider that define the supported schemas at the provider
   */
  public void setSchemas(List<Schema> schemas)
  {
    setAttribute(AttributeNames.RFC7643.SCHEMAS, schemas);
  }


  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static class MetaConfigurationBuilder
  {

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private ServiceProvider serviceProvider;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private List<ResourceType> resourceTypes;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private List<Schema> schemas;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    MetaConfigurationBuilder()
    {}

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MetaConfiguration.MetaConfigurationBuilder serviceProvider(final ServiceProvider serviceProvider)
    {
      this.serviceProvider = serviceProvider;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MetaConfiguration.MetaConfigurationBuilder resourceTypes(final List<ResourceType> resourceTypes)
    {
      this.resourceTypes = resourceTypes;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MetaConfiguration.MetaConfigurationBuilder schemas(final List<Schema> schemas)
    {
      this.schemas = schemas;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MetaConfiguration build()
    {
      return new MetaConfiguration(this.serviceProvider, this.resourceTypes, this.schemas);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString()
    {
      return "MetaConfiguration.MetaConfigurationBuilder(serviceProvider=" + this.serviceProvider + ", resourceTypes="
             + this.resourceTypes + ", schemas=" + this.schemas + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static MetaConfiguration.MetaConfigurationBuilder builder()
  {
    return new MetaConfiguration.MetaConfigurationBuilder();
  }
}
