// Generated by delombok at Tue Nov 04 13:11:14 CET 2025
package de.captaingoldfish.scim.sdk.client.keys;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import de.captaingoldfish.scim.sdk.client.exceptions.KeyStoreReadingException;


/**
 * author Pascal Knueppel <br>
 * created at: 09.12.2019 - 08:20 <br>
 * <br>
 * this class will be used to have the usage of a keystore wrapped in a single place. Means we will hold the
 * password of the keystore, the aliases and the key passwords within this wrapper
 */
public class KeyStoreWrapper
{

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(KeyStoreWrapper.class);

  private static final String COULD_NOT_ACCESS_KEYSTORE = "could not access the given keystore";

  /**
   * the keystore that is the main object of this class
   */
  private KeyStore keyStore;

  /**
   * the password to access the keystore
   */
  private String keystorePassword;

  /**
   * a list of aliases within the keystore that have a matching key-password entry
   */
  private Map<String, AliasPasswordPair> keystoreEntries = new HashMap<>();

  /**
   * constructor to befill the entries for this class<br>
   * it is expected that the keystore-password has already been entered into the keystore object therefore we
   * wont need it anymore for the keystore.
   *
   * @param keyStore the keystore that should be accessible
   * @param privateKeyPassword the password used to access the private keys (the keystore is expected to contain
   *          a single entry)
   */
  public KeyStoreWrapper(KeyStore keyStore, String privateKeyPassword)
  {
    this.keyStore = keyStore;
    this.keystorePassword = privateKeyPassword;
  }

  /**
   * constructor to befill the entries for this class<br>
   * it is expected that the keystore-password has already been entered into the keystore object therefore we
   * wont need it anymore<br>
   * <br>
   * <b>The keystore is expected to be of type JKS</b>
   *
   * @param keyStore the keystore that should be accessible
   * @param keystorePassword the keystore to open the keystore
   */
  public KeyStoreWrapper(byte[] keyStore, String keystorePassword)
  {
    this(keyStore, KeyStoreSupporter.KeyStoreType.JKS, keystorePassword);
  }

  /**
   * constructor to befill the entries for this class<br>
   * it is expected that the keystore-password has already been entered into the keystore object therefore we
   * wont need it anymore
   *
   * @param keyStore the keystore that should be accessible
   * @param keyStoreType the type of the keystore
   * @param keystorePassword the keystore to open the keystore
   */
  public KeyStoreWrapper(byte[] keyStore, KeyStoreSupporter.KeyStoreType keyStoreType, String keystorePassword)
  {
    this(new ByteArrayInputStream(keyStore), keyStoreType, keystorePassword);
  }

  /**
   * constructor to befill the entries for this class<br>
   * it is expected that the keystore-password has already been entered into the keystore object therefore we
   * wont need it anymore<br>
   * <br>
   * <b>The keystore is expected to be of type JKS</b>
   *
   * @param keyStore the keystore that should be accessible
   * @param keystorePassword the keystore to open the keystore
   */
  public KeyStoreWrapper(InputStream keyStore, String keystorePassword)
  {
    this(keyStore, KeyStoreSupporter.KeyStoreType.JKS, keystorePassword);
  }

  /**
   * constructor to befill the entries for this class<br>
   * it is expected that the keystore-password has already been entered into the keystore object therefore we
   * wont need it anymore
   *
   * @param keyStore the keystore that should be accessible
   * @param keyStoreType the type of the keystore
   * @param keystorePassword the keystore to open the keystore
   */
  public KeyStoreWrapper(InputStream keyStore, KeyStoreSupporter.KeyStoreType keyStoreType, String keystorePassword)
  {
    this.keyStore = KeyStoreSupporter.readKeyStore(keyStore, keyStoreType, keystorePassword);
    this.keystorePassword = keystorePassword;
  }

  /**
   * constructor to befill the entries for this class<br>
   * it is expected that the keystore-password has already been entered into the keystore object therefore we
   * wont need it anymore
   *
   * @param keyStore the keystore that should be accessible
   * @param keystorePassword the keystore to open the keystore
   * @param aliasPasswordPair a single alias key-password pair to access at least a single entry within the
   *          keystore
   * @param aliasPasswordPairs a list of alias key-password pairs to access other entreies as well
   */
  public KeyStoreWrapper(KeyStore keyStore,
                         String keystorePassword,
                         AliasPasswordPair aliasPasswordPair,
                         AliasPasswordPair... aliasPasswordPairs)
  {
    this(keyStore, keystorePassword);
    this.keystoreEntries.put(aliasPasswordPair.getAlias(), aliasPasswordPair);
    if (aliasPasswordPairs != null)
    {
      Arrays.stream(aliasPasswordPairs).forEach(app -> keystoreEntries.put(app.getAlias(), app));
    }
  }

  /**
   * constructor to befill the entries for this class
   *
   * @param keyStore the keystore that should be accessible
   * @param keyStoreType to resolve the given keystore into its appropriate type
   * @param keystorePassword the password to access the keystore if necessary
   * @param aliasPasswordPair a single alias key-password pair to access at least a single entry within the
   *          keystore
   * @param aliasPasswordPairs a list of alias key-password pairs to access other entreies as well
   */
  public KeyStoreWrapper(byte[] keyStore,
                         KeyStoreSupporter.KeyStoreType keyStoreType,
                         String keystorePassword,
                         AliasPasswordPair aliasPasswordPair,
                         AliasPasswordPair... aliasPasswordPairs)
  {
    this(KeyStoreSupporter.readKeyStore(keyStore, keyStoreType, keystorePassword), keystorePassword, aliasPasswordPair,
         aliasPasswordPairs);
    this.keystorePassword = keystorePassword;
  }

  /**
   * constructor to befill the entries for this class
   *
   * @param keyStore the keystore that should be accessible. <b>It is necessary for the keystore to have an
   *          appropriate file ending like 'jks', 'jceks', 'p12' or 'pfx'!</b>
   * @param keystorePassword the password to access the keystore if necessary
   * @param aliasPasswordPair a single alias key-password pair to access at least a single entry within the
   *          keystore
   * @param aliasPasswordPairs a list of alias key-password pairs to access other entreies as well
   */
  public KeyStoreWrapper(File keyStore,
                         String keystorePassword,
                         AliasPasswordPair aliasPasswordPair,
                         AliasPasswordPair... aliasPasswordPairs)
  {
    this(KeyStoreSupporter.readKeyStore(keyStore, keystorePassword), keystorePassword, aliasPasswordPair,
         aliasPasswordPairs);
    this.keystorePassword = keystorePassword;
  }

  /**
   * will extract the private key for the given alias
   *
   * @param alias the keystore entry to get the private key from
   * @return the private key of the alias
   */
  public Optional<PrivateKey> getPrivateKey(String alias)
  {
    if (keyStore == null || StringUtils.isBlank(alias))
    {
      return Optional.empty();
    }
    AliasPasswordPair aliasPasswordPair = keystoreEntries.get(alias);
    try
    {
      PrivateKey privateKey;
      if (aliasPasswordPair == null)
      {
        privateKey = (PrivateKey)keyStore.getKey(alias, keystorePassword.toCharArray());
      }
      else
      {
        privateKey = (PrivateKey)keyStore.getKey(alias, aliasPasswordPair.getKeyPassword().toCharArray());
      }
      if (privateKey == null && log.isWarnEnabled())
      {
        log.warn("No private key found for alias: {}", alias);
      }
      return Optional.ofNullable(privateKey);
    }
    catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e)
    {
      throw new KeyStoreReadingException("Could not read keystore entry with alias: " + alias, e);
    }
  }

  /**
   * this method will extract a private key with the given alias and the given password
   *
   * @param alias the alias that holds the private key
   * @param password the password to access the private key
   * @return the private key or null if no entry was found
   */
  public Optional<PrivateKey> getPrivateKey(String alias, String password)
  {
    if (keyStore == null || StringUtils.isBlank(alias) || password == null)
    {
      return Optional.empty();
    }
    try
    {
      PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, password.toCharArray());
      if (privateKey == null && log.isWarnEnabled())
      {
        log.warn("No private key found for alias: {}", alias);
      }
      return Optional.ofNullable(privateKey);
    }
    catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e)
    {
      throw new KeyStoreReadingException("Could not read keystore entry with alias: " + alias, e);
    }
  }

  /**
   * will read the certificate from the given alias
   *
   * @param alias the keystore entry to read
   * @return the certificate under the given keystore entry
   */
  public Optional<X509Certificate> getCertificate(String alias)
  {
    if (keyStore == null || StringUtils.isBlank(alias))
    {
      return Optional.empty();
    }
    try
    {
      X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(alias);
      if (x509Certificate == null && log.isWarnEnabled())
      {
        log.warn("No certificate entry found for alias: {}", alias);
      }
      return Optional.ofNullable(x509Certificate);
    }
    catch (KeyStoreException e)
    {
      throw new KeyStoreReadingException("Could not read certificate with alias: " + alias, e);
    }
  }

  /**
   * will return all aliases as list. <br>
   * this is just a convenience method to prevent handling with {@link KeyStoreException}
   */
  public List<String> getAliasesAsList()
  {
    if (keyStore == null)
    {
      throw new KeyStoreReadingException(COULD_NOT_ACCESS_KEYSTORE);
    }
    try
    {
      Enumeration<String> aliasEnumeration = keyStore.aliases();
      List<String> aliases = new ArrayList<>();
      while (aliasEnumeration.hasMoreElements())
      {
        aliases.add(aliasEnumeration.nextElement());
      }
      return aliases;
    }
    catch (KeyStoreException e)
    {
      throw new KeyStoreReadingException(COULD_NOT_ACCESS_KEYSTORE, e);
    }
  }


  /**
   * used as data holder to hold the key-passwords for any alias
   */
  public static class AliasPasswordPair
  {

    /**
     * the alias of the given keystore {@link #keyStore}
     */
    private String alias;

    /**
     * the key-password to access the private key under {@link #alias}
     */
    private String keyPassword;

    /**
     * the alias of the given keystore {@link #keyStore}
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAlias()
    {
      return this.alias;
    }

    /**
     * the key-password to access the private key under {@link #alias}
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getKeyPassword()
    {
      return this.keyPassword;
    }

    /**
     * Creates a new {@code AliasPasswordPair} instance.
     *
     * @param alias the alias of the given keystore {@link #keyStore}
     * @param keyPassword the key-password to access the private key under {@link #alias}
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AliasPasswordPair(final String alias, final String keyPassword)
    {
      this.alias = alias;
      this.keyPassword = keyPassword;
    }
  }

  /**
   * the keystore that is the main object of this class
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public KeyStore getKeyStore()
  {
    return this.keyStore;
  }

  /**
   * the password to access the keystore
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getKeystorePassword()
  {
    return this.keystorePassword;
  }

  /**
   * a list of aliases within the keystore that have a matching key-password entry
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, AliasPasswordPair> getKeystoreEntries()
  {
    return this.keystoreEntries;
  }

  /**
   * the keystore that is the main object of this class
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setKeyStore(final KeyStore keyStore)
  {
    this.keyStore = keyStore;
  }

  /**
   * the password to access the keystore
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setKeystorePassword(final String keystorePassword)
  {
    this.keystorePassword = keystorePassword;
  }

  /**
   * a list of aliases within the keystore that have a matching key-password entry
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setKeystoreEntries(final Map<String, AliasPasswordPair> keystoreEntries)
  {
    this.keystoreEntries = keystoreEntries;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o)
  {
    if (o == this)
      return true;
    if (!(o instanceof KeyStoreWrapper))
      return false;
    final KeyStoreWrapper other = (KeyStoreWrapper)o;
    if (!other.canEqual((java.lang.Object)this))
      return false;
    final java.lang.Object this$keyStore = this.getKeyStore();
    final java.lang.Object other$keyStore = other.getKeyStore();
    if (this$keyStore == null ? other$keyStore != null : !this$keyStore.equals(other$keyStore))
      return false;
    final java.lang.Object this$keystorePassword = this.getKeystorePassword();
    final java.lang.Object other$keystorePassword = other.getKeystorePassword();
    if (this$keystorePassword == null ? other$keystorePassword != null
      : !this$keystorePassword.equals(other$keystorePassword))
      return false;
    final java.lang.Object this$keystoreEntries = this.getKeystoreEntries();
    final java.lang.Object other$keystoreEntries = other.getKeystoreEntries();
    if (this$keystoreEntries == null ? other$keystoreEntries != null
      : !this$keystoreEntries.equals(other$keystoreEntries))
      return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other)
  {
    return other instanceof KeyStoreWrapper;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode()
  {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $keyStore = this.getKeyStore();
    result = result * PRIME + ($keyStore == null ? 43 : $keyStore.hashCode());
    final java.lang.Object $keystorePassword = this.getKeystorePassword();
    result = result * PRIME + ($keystorePassword == null ? 43 : $keystorePassword.hashCode());
    final java.lang.Object $keystoreEntries = this.getKeystoreEntries();
    result = result * PRIME + ($keystoreEntries == null ? 43 : $keystoreEntries.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString()
  {
    return "KeyStoreWrapper(keyStore=" + this.getKeyStore() + ", keystorePassword=" + this.getKeystorePassword()
           + ", keystoreEntries=" + this.getKeystoreEntries() + ")";
  }
}
