// Generated by delombok at Tue Nov 04 13:11:14 CET 2025
package de.captaingoldfish.scim.sdk.client.http;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;


/**
 * author Pascal Knueppel <br>
 * created at: 11.12.2019 - 15:51 <br>
 * <br>
 * wrapper class for basic auth details
 */
public class BasicAuth
{

  /**
   * the username for basic authentication
   */
  private String username;

  /**
   * the password for basic authentication
   */
  private String password;

  /**
   * generates a basic authentication header value
   */
  public String getAuthorizationHeaderValue()
  {
    byte[] encoded = (Optional.ofNullable(username).orElse("") + ":"
                      + Optional.ofNullable(password).orElse("")).getBytes(StandardCharsets.UTF_8);
    return "Basic " + Base64.getEncoder().encodeToString(encoded);
  }

  /**
   * Creates a new {@code BasicAuth} instance.
   *
   * @param username the username for basic authentication
   * @param password the password for basic authentication
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  BasicAuth(final String username, final String password)
  {
    this.username = username;
    this.password = password;
  }


  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static class BasicAuthBuilder
  {

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String username;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String password;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    BasicAuthBuilder()
    {}

    /**
     * the username for basic authentication
     * 
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BasicAuth.BasicAuthBuilder username(final String username)
    {
      this.username = username;
      return this;
    }

    /**
     * the password for basic authentication
     * 
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BasicAuth.BasicAuthBuilder password(final String password)
    {
      this.password = password;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BasicAuth build()
    {
      return new BasicAuth(this.username, this.password);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString()
    {
      return "BasicAuth.BasicAuthBuilder(username=" + this.username + ", password=" + this.password + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static BasicAuth.BasicAuthBuilder builder()
  {
    return new BasicAuth.BasicAuthBuilder();
  }
}
