/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.client.response;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import de.captaingoldfish.scim.sdk.client.http.HttpResponse;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import de.captaingoldfish.scim.sdk.common.response.ErrorResponse;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerResponse<T extends ScimObjectNode> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServerResponse.class);
    private final HttpResponse httpResponse;
    private final boolean success;
    private T resource;
    private ErrorResponse errorResponse;
    private Boolean validScimResponse;
    private Class<T> type;
    private Function<HttpResponse, Boolean> isResponseParseable;
    private Map<String, String> requiredResponseHeaders;

    public ServerResponse(HttpResponse httpResponse, boolean expectedResponseCode, Class<T> type, Function<HttpResponse, Boolean> isResponseParseable, Map<String, String> requiredResponseHeaders) {
        this.httpResponse = httpResponse;
        this.requiredResponseHeaders = requiredResponseHeaders;
        this.success = expectedResponseCode && this.isValidScimResponse();
        this.type = type;
        this.isResponseParseable = isResponseParseable;
    }

    public ServerResponse(HttpResponse httpResponse, boolean expectedResponseCode, T resource) {
        this.httpResponse = httpResponse;
        this.success = expectedResponseCode;
        this.resource = resource;
        this.isResponseParseable = response -> false;
    }

    public T getResource() {
        boolean isParseable;
        if (this.resource != null) {
            return this.resource;
        }
        boolean isSuccessResponse = this.success && StringUtils.isNotBlank((CharSequence)this.getResponseBody()) && this.isValidScimResponse();
        Boolean result = this.isResponseParseable.apply(this.httpResponse);
        boolean bl = isParseable = result != null && result != false;
        if (isParseable || isSuccessResponse) {
            this.resource = this.getResource(this.type);
        }
        return this.resource;
    }

    public <R extends ScimObjectNode> R getResource(Class<R> responseType) {
        return (R)((ScimObjectNode)JsonHelper.readJsonDocument((String)this.getResponseBody(), responseType));
    }

    public boolean isValidScimResponse() {
        if (this.validScimResponse == null) {
            this.validScimResponse = this.doesHeaderMapContain(this.getHttpHeaders(), this.requiredResponseHeaders) && (this.getResponseBody() != null && JsonHelper.isValidJson((String)this.getResponseBody()) || this.getResponseBody() == null);
        }
        return this.validScimResponse;
    }

    public ErrorResponse getErrorResponse() {
        if (this.errorResponse == null && !this.success && StringUtils.isNotBlank((CharSequence)this.getResponseBody()) && this.isValidScimResponse() && this.isUriInSchemasElement("urn:ietf:params:scim:api:messages:2.0:Error")) {
            this.errorResponse = (ErrorResponse)JsonHelper.readJsonDocument((String)this.getResponseBody(), ErrorResponse.class);
        }
        return this.errorResponse;
    }

    public Map<String, String> getHttpHeaders() {
        return this.httpResponse.getResponseHeaders();
    }

    public String getResponseBody() {
        return this.httpResponse.getResponseBody();
    }

    public int getHttpStatus() {
        return this.httpResponse.getHttpStatusCode();
    }

    private boolean doesHeaderMapContain(Map<String, String> httpHeaders, Map<String, String> expectedHttpHeaders) {
        boolean allHeadersPresent = true;
        for (Map.Entry<String, String> keyValue : expectedHttpHeaders.entrySet()) {
            boolean isHeaderPresent;
            String headerName = keyValue.getKey();
            String expectedValue = keyValue.getValue();
            List headerNameList = httpHeaders.keySet().stream().filter(name -> name.equalsIgnoreCase(headerName)).collect(Collectors.toList());
            if (headerNameList.size() > 1) {
                log.info("Could not validate header value for duplicate headerName found in response: {} -> {}", (Object)headerName, (Object)String.join((CharSequence)", ", headerNameList));
            }
            boolean bl = isHeaderPresent = headerNameList.size() == 1 && StringUtils.startsWithIgnoreCase((CharSequence)httpHeaders.get(headerNameList.get(0)), (CharSequence)expectedValue);
            if (isHeaderPresent) {
                log.trace("Successfully validated {} header with value '{}'", (Object)headerName, (Object)expectedValue);
                continue;
            }
            log.info("Expected header {} was not found in response '{}'", (Object)headerName, (Object)expectedValue);
            allHeadersPresent = false;
        }
        return allHeadersPresent;
    }

    private boolean isUriInSchemasElement(String uri) {
        if (!this.isValidScimResponse() || StringUtils.isBlank((CharSequence)this.getResponseBody())) {
            return false;
        }
        ScimObjectNode scimObjectNode = (ScimObjectNode)JsonHelper.readJsonDocument((String)this.getResponseBody(), ScimObjectNode.class);
        ArrayNode schemasNode = (ArrayNode)scimObjectNode.get("schemas");
        if (schemasNode == null || schemasNode.isEmpty()) {
            return false;
        }
        for (JsonNode jsonNode : schemasNode) {
            if (!uri.equals(jsonNode.textValue())) continue;
            return true;
        }
        return false;
    }

    @Generated
    public boolean isSuccess() {
        return this.success;
    }

    @Generated
    protected Class<T> getType() {
        return this.type;
    }

    @Generated
    protected Map<String, String> getRequiredResponseHeaders() {
        return this.requiredResponseHeaders;
    }
}

